/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.sasl.PlainSASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.jboss.logging.Logger;

public class ProtonServerReceiverContext
extends ProtonInitializable
implements ProtonDeliveryHandler {
    private static final Logger log = Logger.getLogger(ProtonServerReceiverContext.class);
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionContext protonSession;
    protected final Receiver receiver;
    protected SimpleString address;
    protected final AMQPSessionCallback sessionSPI;
    private final int amqpCredits;
    private final int minCreditRefresh;
    private TerminusExpiryPolicy expiryPolicy;

    public ProtonServerReceiverContext(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver) {
        this.connection = connection;
        this.protonSession = protonSession;
        this.receiver = receiver;
        this.sessionSPI = sessionSPI;
        this.amqpCredits = connection.getAmqpCredits();
        this.minCreditRefresh = connection.getAmqpLowCredits();
    }

    @Override
    public void onFlow(int credits, boolean drain) {
        this.flow(Math.min(credits, this.amqpCredits), this.amqpCredits);
    }

    @Override
    public void initialise() throws Exception {
        super.initialise();
        Target target = (Target)this.receiver.getRemoteTarget();
        this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
        this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        if (target != null) {
            List<Symbol> list;
            if (target.getDynamic()) {
                this.address = SimpleString.toSimpleString((String)this.sessionSPI.tempQueueName());
                RoutingType defRoutingType = this.getRoutingType(target.getCapabilities(), this.address);
                try {
                    this.sessionSPI.createTemporaryQueue(this.address, defRoutingType);
                }
                catch (ActiveMQAMQPSecurityException e) {
                    throw e;
                }
                catch (ActiveMQSecurityException e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingTempDestination(e.getMessage());
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
                this.expiryPolicy = target.getExpiryPolicy() != null ? target.getExpiryPolicy() : TerminusExpiryPolicy.LINK_DETACH;
                target.setAddress(this.address.toString());
            } else {
                this.address = SimpleString.toSimpleString((String)target.getAddress());
                if (this.address != null && !this.address.isEmpty()) {
                    RoutingType defRoutingType = this.getRoutingType(target.getCapabilities(), this.address);
                    try {
                        if (!this.sessionSPI.bindingQuery(this.address, defRoutingType)) {
                            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist();
                        }
                    }
                    catch (ActiveMQAMQPNotFoundException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                        throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                    }
                    try {
                        this.sessionSPI.check(this.address, CheckType.SEND, new SecurityAuth(){

                            public String getUsername() {
                                String username = null;
                                SASLResult saslResult = ProtonServerReceiverContext.this.connection.getSASLResult();
                                if (saslResult != null) {
                                    username = saslResult.getUser();
                                }
                                return username;
                            }

                            public String getPassword() {
                                String password = null;
                                SASLResult saslResult = ProtonServerReceiverContext.this.connection.getSASLResult();
                                if (saslResult != null && saslResult instanceof PlainSASLResult) {
                                    password = ((PlainSASLResult)saslResult).getPassword();
                                }
                                return password;
                            }

                            public RemotingConnection getRemotingConnection() {
                                return ProtonServerReceiverContext.this.connection.connectionCallback.getProtonConnectionDelegate();
                            }
                        });
                    }
                    catch (ActiveMQSecurityException e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingProducer(e.getMessage());
                    }
                }
            }
            Symbol[] remoteDesiredCapabilities = this.receiver.getRemoteDesiredCapabilities();
            if (remoteDesiredCapabilities != null && (list = Arrays.asList(remoteDesiredCapabilities)).contains(AmqpSupport.DELAYED_DELIVERY)) {
                this.receiver.setOfferedCapabilities(new Symbol[]{AmqpSupport.DELAYED_DELIVERY});
            }
        }
        this.flow(this.amqpCredits, this.minCreditRefresh);
    }

    public RoutingType getRoutingType(Receiver receiver, SimpleString address) {
        Target target = (Target)receiver.getRemoteTarget();
        return target != null ? this.getRoutingType(target.getCapabilities(), address) : this.getRoutingType((Symbol[])null, address);
    }

    private RoutingType getRoutingType(Symbol[] symbols, SimpleString address) {
        if (symbols != null) {
            for (Symbol symbol : symbols) {
                if (AmqpSupport.TEMP_TOPIC_CAPABILITY.equals(symbol) || AmqpSupport.TOPIC_CAPABILITY.equals(symbol)) {
                    return RoutingType.MULTICAST;
                }
                if (!AmqpSupport.TEMP_QUEUE_CAPABILITY.equals(symbol) && !AmqpSupport.QUEUE_CAPABILITY.equals(symbol)) continue;
                return RoutingType.ANYCAST;
            }
        }
        return this.sessionSPI.getDefaultRoutingType(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        try {
            if (!delivery.isReadable()) {
                return;
            }
            if (delivery.isAborted()) {
                Receiver receiver = (Receiver)delivery.getLink();
                receiver.advance();
                delivery.settle();
                if (!receiver.getDrain()) {
                    receiver.flow(1);
                }
                return;
            }
            if (delivery.isPartial()) {
                return;
            }
            Receiver receiver = (Receiver)delivery.getLink();
            Transaction tx = null;
            ReadableBuffer data = receiver.recv();
            receiver.advance();
            if (delivery.getRemoteState() instanceof TransactionalState) {
                TransactionalState txState = (TransactionalState)delivery.getRemoteState();
                tx = this.sessionSPI.getTransaction(txState.getTxnId(), false);
            }
            this.sessionSPI.serverSend(this, tx, receiver, delivery, this.address, delivery.getMessageFormat(), data);
            this.flow(this.amqpCredits, this.minCreditRefresh);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            Rejected rejected = new Rejected();
            ErrorCondition condition = new ErrorCondition();
            if (e instanceof ActiveMQSecurityException) {
                condition.setCondition(AmqpError.UNAUTHORIZED_ACCESS);
            } else {
                condition.setCondition(Symbol.valueOf((String)"failed"));
            }
            condition.setDescription(e.getMessage());
            rejected.setError(condition);
            this.connection.lock();
            try {
                delivery.disposition((DeliveryState)rejected);
                delivery.settle();
            }
            finally {
                this.connection.unlock();
            }
        }
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        this.protonSession.removeReceiver(this.receiver);
        Target target = (Target)this.receiver.getRemoteTarget();
        if (target != null && target.getDynamic() && (target.getExpiryPolicy() == TerminusExpiryPolicy.LINK_DETACH || target.getExpiryPolicy() == TerminusExpiryPolicy.SESSION_END)) {
            try {
                this.sessionSPI.removeTemporaryQueue(SimpleString.toSimpleString((String)target.getAddress()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        this.receiver.setCondition(condition);
        this.close(false);
    }

    public void flow(int credits, int threshold) {
        if (this.sessionSPI != null) {
            if (this.receiver.getCredit() <= threshold) {
                this.sessionSPI.offerProducerCredit(this.address, credits, threshold, this.receiver);
            }
        } else {
            this.connection.lock();
            try {
                this.receiver.flow(credits);
            }
            finally {
                this.connection.unlock();
            }
            this.connection.flush();
        }
    }

    public void drain(int credits) {
        this.connection.lock();
        try {
            this.receiver.drain(credits);
        }
        finally {
            this.connection.unlock();
        }
        this.connection.flush();
    }

    public int drained() {
        return this.receiver.drained();
    }

    public boolean isDraining() {
        return this.receiver.draining();
    }
}

