/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.singleton.LocalSingletonServiceContext;
import org.wildfly.clustering.singleton.service.SingletonService;

public class LocalSingletonService
implements SingletonService {
    private final Service service;
    private final Supplier<Group> group;

    public LocalSingletonService(Service service, LocalSingletonServiceContext context) {
        this.service = service;
        this.group = context.getGroup();
    }

    public void start(StartContext context) throws StartException {
        this.service.start(context);
    }

    public void stop(StopContext context) {
        this.service.stop(context);
    }

    public boolean isPrimary() {
        return true;
    }

    public Node getPrimaryProvider() {
        return this.group.get().getLocalMember();
    }

    public Set<Node> getProviders() {
        return Collections.singleton(this.group.get().getLocalMember());
    }
}

