"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Region = exports.DEFAULT_UC_URL = exports.USER_AGENT = void 0;
const urllib_1 = require("urllib");
const os_1 = __importDefault(require("os"));
const package_json_1 = __importDefault(require("./package.json"));
const kodo_auth_1 = require("./kodo-auth");
exports.USER_AGENT = `Qiniu-Kodo-S3-Adapter-NodeJS-SDK/${package_json_1.default.version} (${os_1.default.type()}; ${os_1.default.platform()}; ${os_1.default.arch()}; )/kodo/region`;
exports.DEFAULT_UC_URL = 'https://uc.qbox.me';
class Region {
    constructor(id, s3Id, label, translatedLabels) {
        this.id = id;
        this.s3Id = s3Id;
        this.label = label;
        this.translatedLabels = translatedLabels;
        this.upUrls = [];
        this.ucUrls = [];
        this.rsUrls = [];
        this.rsfUrls = [];
        this.apiUrls = [];
        this.s3Urls = [];
    }
    static getAll(options) {
        var _a;
        const ucUrl = (_a = options.ucUrl) !== null && _a !== void 0 ? _a : exports.DEFAULT_UC_URL;
        const requestURI = `${ucUrl}/regions`;
        return new Promise((resolve, reject) => {
            let requestInfo = undefined;
            const beginTime = new Date().getTime();
            Region.httpClient.request(requestURI, {
                method: 'GET',
                dataType: 'json',
                headers: {
                    'user-agent': exports.USER_AGENT,
                    'authorization': kodo_auth_1.generateAccessTokenV2(options.accessKey, options.secretKey, requestURI, 'GET'),
                },
                retry: 5,
                retryDelay: 500,
                isRetry: Region.isRetry,
                beforeRequest: (info) => {
                    requestInfo = {
                        url: requestURI,
                        method: info.method,
                        headers: info.headers,
                    };
                    if (options.requestCallback) {
                        options.requestCallback(requestInfo);
                    }
                },
            }).then((response) => {
                var _a;
                var _b;
                const responseInfo = {
                    request: requestInfo,
                    statusCode: response.status,
                    headers: response.headers,
                    data: response.data,
                    interval: new Date().getTime() - beginTime,
                };
                try {
                    if (response.status >= 200 && response.status < 400) {
                        (_a = (_b = response.data).regions) !== null && _a !== void 0 ? _a : (_b.regions = []);
                        const regions = response.data.regions.map((r) => Region.fromResponseBody(ucUrl, r));
                        resolve(regions);
                    }
                    else {
                        const error = Region.extraError(response);
                        responseInfo.error = error;
                        reject(error);
                    }
                }
                finally {
                    if (options.responseCallback) {
                        options.responseCallback(responseInfo);
                    }
                }
            }).catch((err) => {
                const responseInfo = {
                    request: requestInfo,
                    interval: new Date().getTime() - beginTime,
                    error: err,
                };
                if (options.responseCallback) {
                    options.responseCallback(responseInfo);
                }
                reject(err);
            });
        });
    }
    static query(options) {
        var _a;
        const ucUrl = (_a = options.ucUrl) !== null && _a !== void 0 ? _a : exports.DEFAULT_UC_URL;
        return new Promise((resolve, reject) => {
            const requestURI = `${ucUrl}/v4/query`;
            let requestInfo = undefined;
            const beginTime = new Date().getTime();
            Region.httpClient.request(requestURI, {
                data: { ak: options.accessKey, bucket: options.bucketName },
                dataAsQueryString: true,
                dataType: 'json',
                headers: { 'user-agent': exports.USER_AGENT },
                retry: 5,
                retryDelay: 500,
                isRetry: Region.isRetry,
                beforeRequest: (info) => {
                    requestInfo = {
                        url: requestURI,
                        method: info.method,
                        headers: info.headers,
                    };
                    if (options.requestCallback) {
                        options.requestCallback(requestInfo);
                    }
                },
            }).then((response) => {
                const responseInfo = {
                    request: requestInfo,
                    statusCode: response.status,
                    headers: response.headers,
                    data: response.data,
                    interval: new Date().getTime() - beginTime,
                };
                try {
                    if (response.status >= 200 && response.status < 400) {
                        let r = null;
                        try {
                            r = response.data.hosts[0];
                        }
                        catch (_a) {
                            const error = new Error('Invalid uc query v4 body');
                            responseInfo.error = error;
                            reject(error);
                            return;
                        }
                        ;
                        const region = Region.fromResponseBody(ucUrl, r);
                        resolve(region);
                    }
                    else {
                        const error = Region.extraError(response);
                        responseInfo.error = error;
                        reject(error);
                    }
                }
                finally {
                    if (options.responseCallback) {
                        options.responseCallback(responseInfo);
                    }
                }
            }).catch((err) => {
                const responseInfo = {
                    request: requestInfo,
                    interval: new Date().getTime() - beginTime,
                    error: err,
                };
                if (options.responseCallback) {
                    options.responseCallback(responseInfo);
                }
                reject(err);
            });
        });
    }
    static extraError(response) {
        let error;
        if (response.data.error) {
            error = new Error(response.data.error);
        }
        else {
            try {
                const data = JSON.parse(response.data);
                if (data.error) {
                    error = new Error(data.error);
                }
                else {
                    error = new Error(response.res.statusMessage);
                }
            }
            catch (_a) {
                error = new Error(response.res.statusMessage);
            }
        }
        return error;
    }
    static isRetry(response) {
        const dontRetryStatusCodes = [501, 579, 599, 608, 612, 614, 616,
            618, 630, 631, 632, 640, 701];
        return !response.headers['x-reqid'] ||
            response.status >= 500 && !dontRetryStatusCodes.find((status) => status === response.status);
    }
    static fromResponseBody(ucUrl, r) {
        var _a;
        const translatedDescriptions = {};
        for (const fieldName in r) {
            if (fieldName.startsWith("description_")) {
                const langName = fieldName.substring("description_".length);
                translatedDescriptions[langName] = r[fieldName];
            }
        }
        const region = new Region((_a = r.region) !== null && _a !== void 0 ? _a : r.id, r.s3.region_alias, r.description, translatedDescriptions);
        const domain2Url = (domain) => {
            const url = new URL(ucUrl);
            return new URL(`${url.protocol}//${domain}`).toString();
        };
        region.upUrls = r.up.domains.map(domain2Url);
        region.ucUrls = r.uc.domains.map(domain2Url);
        region.rsUrls = r.rs.domains.map(domain2Url);
        region.rsfUrls = r.rsf.domains.map(domain2Url);
        region.apiUrls = r.api.domains.map(domain2Url);
        region.s3Urls = r.s3.domains.map(domain2Url);
        return region;
    }
}
exports.Region = Region;
Region.httpClient = new urllib_1.HttpClient2();
//# sourceMappingURL=region.js.map