import { Region } from './region';
import { AdapterOption } from './adapter';
export interface S3IdEndpoint {
    s3Id: string;
    s3Endpoint: string;
}
export declare class RegionService {
    private readonly adapterOption;
    private allRegions;
    private readonly allRegionsLock;
    constructor(adapterOption: AdapterOption);
    getAllRegions(): Promise<Array<Region>>;
    clearCache(): void;
    getS3Endpoint(s3RegionId?: string): Promise<S3IdEndpoint>;
    fromKodoRegionIdToS3Id(regionId: string): Promise<string>;
    fromS3IdToKodoRegionId(s3Id: string): Promise<string>;
}
//# sourceMappingURL=region_service.d.ts.map