import { HttpMethod, HttpClientResponse } from 'urllib';
import { Throttle } from 'stream-throttle';
import { ErrorType, UplogBuffer } from './uplog';
import FormData from 'form-data';
import { RequestInfo, ResponseInfo } from './adapter';
export interface HttpClientOptions {
    accessKey: string;
    secretKey?: string;
    protocol?: 'http' | 'https';
    timeout?: number | number[];
    userAgent?: string;
    retry?: number;
    retryDelay?: number;
    requestCallback?: (request: RequestInfo) => void;
    responseCallback?: (response: ResponseInfo) => void;
}
export interface RequestStats {
    sdkApiName: string;
    requestsCount: number;
    errorType?: ErrorType;
    errorDescription?: string;
}
export interface URLRequestOptions {
    fullUrl?: boolean;
    appendAuthorization?: boolean;
    method?: HttpMethod;
    path?: string;
    query?: URLSearchParams;
    data?: any;
    dataType?: string;
    form?: FormData;
    streaming?: boolean;
    contentType?: string;
    headers?: {
        [headerName: string]: string;
    };
    uploadProgress?: (uploaded: number, total: number) => void;
    uploadThrottle?: Throttle;
    stats?: RequestStats;
}
export declare class HttpClient {
    private readonly clientOptions;
    private readonly uplogBuffer;
    private static readonly httpClient;
    constructor(clientOptions: HttpClientOptions, uplogBuffer: UplogBuffer);
    call<T = any>(urls: Array<string>, options: URLRequestOptions): Promise<HttpClientResponse<T>>;
    private makeUrl;
    private makeAuthorization;
    private isRetry;
}
//# sourceMappingURL=http-client.d.ts.map