import { RequestInfo, ResponseInfo } from './adapter';
import { RequestStats } from './http-client';
export declare const USER_AGENT: string;
export declare const DEFAULT_UC_URL: string;
export interface RegionRequestOptions {
    timeout?: number | number[];
    retry?: number;
    retryDelay?: number;
    stats?: RequestStats;
}
interface RequestOptions extends RegionRequestOptions {
    accessKey: string;
    ucUrl?: string;
    appName?: string;
    appVersion?: string;
    uplogBufferSize?: number;
    requestCallback?: (request: RequestInfo) => void;
    responseCallback?: (response: ResponseInfo) => void;
}
export interface GetAllOptions extends RequestOptions {
    secretKey: string;
}
export interface QueryOptions extends RequestOptions {
    bucketName: string;
}
export declare class Region {
    readonly id: string;
    readonly s3Id: string;
    readonly label?: string | undefined;
    readonly translatedLabels?: {
        [lang: string]: string;
    } | undefined;
    upUrls: Array<string>;
    ucUrls: Array<string>;
    rsUrls: Array<string>;
    rsfUrls: Array<string>;
    apiUrls: Array<string>;
    s3Urls: Array<string>;
    constructor(id: string, s3Id: string, label?: string | undefined, translatedLabels?: {
        [lang: string]: string;
    } | undefined);
    static getAll(options: GetAllOptions): Promise<Array<Region>>;
    static query(options: QueryOptions): Promise<Region>;
    private static fromResponseBody;
}
export {};
//# sourceMappingURL=region.d.ts.map