"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Region = exports.DEFAULT_UC_URL = exports.USER_AGENT = void 0;
const os_1 = __importDefault(require("os"));
const package_json_1 = __importDefault(require("./package.json"));
const kodo_auth_1 = require("./kodo-auth");
const uplog_1 = require("./uplog");
const http_client_1 = require("./http-client");
exports.USER_AGENT = `Qiniu-Kodo-S3-Adapter-NodeJS-SDK/${package_json_1.default.version} (${os_1.default.type()}; ${os_1.default.platform()}; ${os_1.default.arch()}; )/kodo/region`;
exports.DEFAULT_UC_URL = 'https://uc.qbox.me';
class Region {
    constructor(id, s3Id, label, translatedLabels) {
        this.id = id;
        this.s3Id = s3Id;
        this.label = label;
        this.translatedLabels = translatedLabels;
        this.upUrls = [];
        this.ucUrls = [];
        this.rsUrls = [];
        this.rsfUrls = [];
        this.apiUrls = [];
        this.s3Urls = [];
    }
    static getAll(options) {
        var _a;
        const ucUrl = (_a = options.ucUrl) !== null && _a !== void 0 ? _a : exports.DEFAULT_UC_URL;
        const requestURL = new URL(`${ucUrl}/regions`);
        const uplogBuffer = new uplog_1.UplogBuffer({
            appName: options.appName, appVersion: options.appVersion,
            bufferSize: options.uplogBufferSize,
        });
        const httpClient = new http_client_1.HttpClient({
            accessKey: options.accessKey,
            secretKey: options.secretKey,
            protocol: requestURL.protocol === 'https' ? 'https' : 'http',
            timeout: options.timeout,
            userAgent: exports.USER_AGENT,
            retry: options.retry,
            retryDelay: options.retryDelay,
            requestCallback: options.requestCallback,
            responseCallback: options.responseCallback,
        }, uplogBuffer);
        return new Promise((resolve, reject) => {
            httpClient.call([requestURL.toString()], {
                fullUrl: true,
                appendAuthorization: false,
                method: 'GET',
                dataType: 'json',
                headers: {
                    'authorization': kodo_auth_1.generateAccessTokenV2(options.accessKey, options.secretKey, requestURL.toString(), 'GET'),
                },
                stats: options.stats,
            }).then((response) => {
                var _a;
                var _b;
                (_a = (_b = response.data).regions) !== null && _a !== void 0 ? _a : (_b.regions = []);
                const regions = response.data.regions.map((r) => Region.fromResponseBody(ucUrl, r));
                resolve(regions);
            }, reject);
        });
    }
    static query(options) {
        var _a;
        const ucUrl = (_a = options.ucUrl) !== null && _a !== void 0 ? _a : exports.DEFAULT_UC_URL;
        const requestURL = new URL(`${ucUrl}/v4/query`);
        requestURL.searchParams.append('ak', options.accessKey);
        requestURL.searchParams.append('bucket', options.bucketName);
        const uplogBuffer = new uplog_1.UplogBuffer({
            appName: options.appName, appVersion: options.appVersion,
            bufferSize: options.uplogBufferSize,
        });
        const httpClient = new http_client_1.HttpClient({
            accessKey: options.accessKey,
            protocol: requestURL.protocol === 'https' ? 'https' : 'http',
            timeout: options.timeout,
            userAgent: exports.USER_AGENT,
            retry: options.retry,
            retryDelay: options.retryDelay,
            requestCallback: options.requestCallback,
            responseCallback: options.responseCallback,
        }, uplogBuffer);
        return new Promise((resolve, reject) => {
            httpClient.call([requestURL.toString()], {
                fullUrl: true,
                appendAuthorization: false,
                method: 'GET',
                dataType: 'json',
                stats: options.stats,
            }).then((response) => {
                let r = null;
                try {
                    r = response.data.hosts[0];
                }
                catch (_a) {
                    const error = new Error('Invalid uc query v4 body');
                    reject(error);
                    return;
                }
                ;
                const region = Region.fromResponseBody(ucUrl, r);
                resolve(region);
            }, reject);
        });
    }
    static fromResponseBody(ucUrl, r) {
        var _a;
        const translatedDescriptions = {};
        for (const fieldName in r) {
            if (fieldName.startsWith("description_")) {
                const langName = fieldName.substring("description_".length);
                translatedDescriptions[langName] = r[fieldName];
            }
        }
        const region = new Region((_a = r.region) !== null && _a !== void 0 ? _a : r.id, r.s3.region_alias, r.description, translatedDescriptions);
        const domain2Url = (domain) => {
            const url = new URL(ucUrl);
            return new URL(`${url.protocol}//${domain}`).toString();
        };
        region.upUrls = r.up.domains.map(domain2Url);
        region.ucUrls = r.uc.domains.map(domain2Url);
        region.rsUrls = r.rs.domains.map(domain2Url);
        region.rsfUrls = r.rsf.domains.map(domain2Url);
        region.apiUrls = r.api.domains.map(domain2Url);
        region.s3Urls = r.s3.domains.map(domain2Url);
        return region;
    }
}
exports.Region = Region;
//# sourceMappingURL=region.js.map