/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1 "k8s.io/ingress-nginx/internal/checksum/ingress/apis/checksum/v1"
	checksumv1 "k8s.io/ingress-nginx/internal/checksum/ingress/client/applyconfiguration/checksum/v1"
)

// FakeIngressCheckSums implements IngressCheckSumInterface
type FakeIngressCheckSums struct {
	Fake *FakeTengineV1
	ns   string
}

var ingresschecksumsResource = v1.SchemeGroupVersion.WithResource("ingresschecksums")

var ingresschecksumsKind = v1.SchemeGroupVersion.WithKind("IngressCheckSum")

// Get takes name of the ingressCheckSum, and returns the corresponding ingressCheckSum object, and an error if there is any.
func (c *FakeIngressCheckSums) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.IngressCheckSum, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(ingresschecksumsResource, c.ns, name), &v1.IngressCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IngressCheckSum), err
}

// List takes label and field selectors, and returns the list of IngressCheckSums that match those selectors.
func (c *FakeIngressCheckSums) List(ctx context.Context, opts metav1.ListOptions) (result *v1.IngressCheckSumList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(ingresschecksumsResource, ingresschecksumsKind, c.ns, opts), &v1.IngressCheckSumList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.IngressCheckSumList{ListMeta: obj.(*v1.IngressCheckSumList).ListMeta}
	for _, item := range obj.(*v1.IngressCheckSumList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested ingressCheckSums.
func (c *FakeIngressCheckSums) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(ingresschecksumsResource, c.ns, opts))

}

// Create takes the representation of a ingressCheckSum and creates it.  Returns the server's representation of the ingressCheckSum, and an error, if there is any.
func (c *FakeIngressCheckSums) Create(ctx context.Context, ingressCheckSum *v1.IngressCheckSum, opts metav1.CreateOptions) (result *v1.IngressCheckSum, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(ingresschecksumsResource, c.ns, ingressCheckSum), &v1.IngressCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IngressCheckSum), err
}

// Update takes the representation of a ingressCheckSum and updates it. Returns the server's representation of the ingressCheckSum, and an error, if there is any.
func (c *FakeIngressCheckSums) Update(ctx context.Context, ingressCheckSum *v1.IngressCheckSum, opts metav1.UpdateOptions) (result *v1.IngressCheckSum, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(ingresschecksumsResource, c.ns, ingressCheckSum), &v1.IngressCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IngressCheckSum), err
}

// Delete takes name of the ingressCheckSum and deletes it. Returns an error if one occurs.
func (c *FakeIngressCheckSums) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(ingresschecksumsResource, c.ns, name, opts), &v1.IngressCheckSum{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeIngressCheckSums) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(ingresschecksumsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.IngressCheckSumList{})
	return err
}

// Patch applies the patch and returns the patched ingressCheckSum.
func (c *FakeIngressCheckSums) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.IngressCheckSum, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(ingresschecksumsResource, c.ns, name, pt, data, subresources...), &v1.IngressCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IngressCheckSum), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied ingressCheckSum.
func (c *FakeIngressCheckSums) Apply(ctx context.Context, ingressCheckSum *checksumv1.IngressCheckSumApplyConfiguration, opts metav1.ApplyOptions) (result *v1.IngressCheckSum, err error) {
	if ingressCheckSum == nil {
		return nil, fmt.Errorf("ingressCheckSum provided to Apply must not be nil")
	}
	data, err := json.Marshal(ingressCheckSum)
	if err != nil {
		return nil, err
	}
	name := ingressCheckSum.Name
	if name == nil {
		return nil, fmt.Errorf("ingressCheckSum.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(ingresschecksumsResource, c.ns, *name, types.ApplyPatchType, data), &v1.IngressCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IngressCheckSum), err
}
