/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1 "k8s.io/ingress-nginx/internal/checksum/secret/apis/checksum/v1"
	checksumv1 "k8s.io/ingress-nginx/internal/checksum/secret/client/applyconfiguration/checksum/v1"
)

// FakeSecretCheckSums implements SecretCheckSumInterface
type FakeSecretCheckSums struct {
	Fake *FakeTengineV1
	ns   string
}

var secretchecksumsResource = v1.SchemeGroupVersion.WithResource("secretchecksums")

var secretchecksumsKind = v1.SchemeGroupVersion.WithKind("SecretCheckSum")

// Get takes name of the secretCheckSum, and returns the corresponding secretCheckSum object, and an error if there is any.
func (c *FakeSecretCheckSums) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.SecretCheckSum, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(secretchecksumsResource, c.ns, name), &v1.SecretCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.SecretCheckSum), err
}

// List takes label and field selectors, and returns the list of SecretCheckSums that match those selectors.
func (c *FakeSecretCheckSums) List(ctx context.Context, opts metav1.ListOptions) (result *v1.SecretCheckSumList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(secretchecksumsResource, secretchecksumsKind, c.ns, opts), &v1.SecretCheckSumList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.SecretCheckSumList{ListMeta: obj.(*v1.SecretCheckSumList).ListMeta}
	for _, item := range obj.(*v1.SecretCheckSumList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested secretCheckSums.
func (c *FakeSecretCheckSums) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(secretchecksumsResource, c.ns, opts))

}

// Create takes the representation of a secretCheckSum and creates it.  Returns the server's representation of the secretCheckSum, and an error, if there is any.
func (c *FakeSecretCheckSums) Create(ctx context.Context, secretCheckSum *v1.SecretCheckSum, opts metav1.CreateOptions) (result *v1.SecretCheckSum, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(secretchecksumsResource, c.ns, secretCheckSum), &v1.SecretCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.SecretCheckSum), err
}

// Update takes the representation of a secretCheckSum and updates it. Returns the server's representation of the secretCheckSum, and an error, if there is any.
func (c *FakeSecretCheckSums) Update(ctx context.Context, secretCheckSum *v1.SecretCheckSum, opts metav1.UpdateOptions) (result *v1.SecretCheckSum, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(secretchecksumsResource, c.ns, secretCheckSum), &v1.SecretCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.SecretCheckSum), err
}

// Delete takes name of the secretCheckSum and deletes it. Returns an error if one occurs.
func (c *FakeSecretCheckSums) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(secretchecksumsResource, c.ns, name, opts), &v1.SecretCheckSum{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSecretCheckSums) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(secretchecksumsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.SecretCheckSumList{})
	return err
}

// Patch applies the patch and returns the patched secretCheckSum.
func (c *FakeSecretCheckSums) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SecretCheckSum, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(secretchecksumsResource, c.ns, name, pt, data, subresources...), &v1.SecretCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.SecretCheckSum), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied secretCheckSum.
func (c *FakeSecretCheckSums) Apply(ctx context.Context, secretCheckSum *checksumv1.SecretCheckSumApplyConfiguration, opts metav1.ApplyOptions) (result *v1.SecretCheckSum, err error) {
	if secretCheckSum == nil {
		return nil, fmt.Errorf("secretCheckSum provided to Apply must not be nil")
	}
	data, err := json.Marshal(secretCheckSum)
	if err != nil {
		return nil, err
	}
	name := secretCheckSum.Name
	if name == nil {
		return nil, fmt.Errorf("secretCheckSum.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(secretchecksumsResource, c.ns, *name, types.ApplyPatchType, data), &v1.SecretCheckSum{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.SecretCheckSum), err
}
