/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1 "k8s.io/ingress-nginx/internal/checksum/secret/apis/checksum/v1"
)

// SecretCheckSumLister helps list SecretCheckSums.
// All objects returned here must be treated as read-only.
type SecretCheckSumLister interface {
	// List lists all SecretCheckSums in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.SecretCheckSum, err error)
	// SecretCheckSums returns an object that can list and get SecretCheckSums.
	SecretCheckSums(namespace string) SecretCheckSumNamespaceLister
	SecretCheckSumListerExpansion
}

// secretCheckSumLister implements the SecretCheckSumLister interface.
type secretCheckSumLister struct {
	indexer cache.Indexer
}

// NewSecretCheckSumLister returns a new SecretCheckSumLister.
func NewSecretCheckSumLister(indexer cache.Indexer) SecretCheckSumLister {
	return &secretCheckSumLister{indexer: indexer}
}

// List lists all SecretCheckSums in the indexer.
func (s *secretCheckSumLister) List(selector labels.Selector) (ret []*v1.SecretCheckSum, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SecretCheckSum))
	})
	return ret, err
}

// SecretCheckSums returns an object that can list and get SecretCheckSums.
func (s *secretCheckSumLister) SecretCheckSums(namespace string) SecretCheckSumNamespaceLister {
	return secretCheckSumNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SecretCheckSumNamespaceLister helps list and get SecretCheckSums.
// All objects returned here must be treated as read-only.
type SecretCheckSumNamespaceLister interface {
	// List lists all SecretCheckSums in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.SecretCheckSum, err error)
	// Get retrieves the SecretCheckSum from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.SecretCheckSum, error)
	SecretCheckSumNamespaceListerExpansion
}

// secretCheckSumNamespaceLister implements the SecretCheckSumNamespaceLister
// interface.
type secretCheckSumNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SecretCheckSums in the indexer for a given namespace.
func (s secretCheckSumNamespaceLister) List(selector labels.Selector) (ret []*v1.SecretCheckSum, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SecretCheckSum))
	})
	return ret, err
}

// Get retrieves the SecretCheckSum from the indexer for a given namespace and name.
func (s secretCheckSumNamespaceLister) Get(name string) (*v1.SecretCheckSum, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("secretchecksum"), name)
	}
	return obj.(*v1.SecretCheckSum), nil
}
