//
// ========================================================================
// Copyright (c) 1995-2020 Mort Bay Consulting Pty Ltd and others.
//
// This program and the accompanying materials are made available under
// the terms of the Eclipse Public License 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0
//
// This Source Code may also be made available under the following
// Secondary Licenses when the conditions for such availability set
// forth in the Eclipse Public License, v. 2.0 are satisfied:
// the Apache License v2.0 which is available at
// https://www.apache.org/licenses/LICENSE-2.0
//
// SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
// ========================================================================
//

package org.eclipse.jetty.websocket.javax.tests.coders;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;

/**
 * Example of a valid encoder impl declaring 2 encoders.
 */
public class ValidDualEncoder implements Encoder.Text<Integer>, Encoder.BinaryStream<Long>
{
    @Override
    public void destroy()
    {
    }

    @Override
    public String encode(Integer object) throws EncodeException
    {
        return String.format("[%,d]", object);
    }

    @Override
    public void encode(Long object, OutputStream os) throws EncodeException, IOException
    {
        DataOutputStream data = new DataOutputStream(os);
        data.writeByte((byte)'[');
        data.writeLong(object);
        data.writeByte((byte)']');
        data.flush();
    }

    @Override
    public void init(EndpointConfig config)
    {
    }
}
