# Name #
## Proc Module ##

provides a mechanism to support standalone processes

# Examples #

	processes {
		process echo {
			eho_str "hello, world";
			echo on;
			listen 8888;
			count 1;
			priority 1;
			delay_start 10s;
			respawn off;
		}

		process example {
			count 1;
			priority 0;
			delay_start 0s;
			respawn on;
		}
	}


# Directives #

## process ##

Syntax: **process** `name { }`

Default: `none`

Context: `processes`


## count ##

Syntax: **count** `num`

Default: `1`

Context: `process`

Specify the number of processes which will be forked.


## priority ##

Syntax: **priority** `num`

Default: `0`

Context: `process`

Priority is a value in the range -20 to 20. Lower priorities cause more favorable scheduling.


## delay\_start ##

Syntax: **delay\_start** `time`

Default: `300ms`

Context: `process`

The directive specifies the time to wait before process starts.


## respawn ##

Syntax: **respawn** `on | off`

Default: `on`

Context: `process`

The directive specifies whether the process will be restarted by nginx when it encounters some errors and exits.