#!/usr/bin/perl

# (C) Maxim Dounin

# Tests for random index module.

###############################################################################

use warnings;
use strict;

use Test::More;

BEGIN { use FindBin; chdir($FindBin::Bin); }

use lib 'lib';
use Test::Nginx;

###############################################################################

select STDERR; $| = 1;
select STDOUT; $| = 1;

my $t = Test::Nginx->new()->has(qw/http random_index/)->plan(1);

$t->set_dso("ngx_http_random_index_module", "ngx_http_random_index_module.so");
$t->set_dso("ngx_http_fastcgi_module", "ngx_http_fastcgi_module.so");
$t->set_dso("ngx_http_uwsgi_module", "ngx_http_uwsgi_module.so");
$t->set_dso("ngx_http_scgi_module", "ngx_http_scgi_module.so");

$t->write_file_expand('nginx.conf', <<'EOF');

%%TEST_GLOBALS%%

daemon         off;

%%TEST_GLOBALS_DSO%%

events {
}

http {
    %%TEST_GLOBALS_HTTP%%

    server {
        listen       127.0.0.1:8080;
        server_name  localhost;

        location / {
            random_index on;
        }
    }
}

EOF

my $d = $t->testdir();

mkdir("$d/x");
mkdir("$d/x/test-dir");
symlink("$d/x/test-dir", "$d/x/test-dir-link");

$t->write_file('test-file', 'RIGHT');
symlink("$d/test-file", "$d/x/test-file-link");

$t->run();

###############################################################################

like(http_get('/x/'), qr/RIGHT/s, 'file');

###############################################################################
