
/*
 * Copyright (C) 2010-2013 Alibaba Group Holding Limited
 */


#ifndef _NGX_SYSLOG_H_INCLUDED_
#define _NGX_SYSLOG_H_INCLUDED_


#define NGX_SYSLOG_EMERG        0       /* system is unusable */
#define NGX_SYSLOG_ALERT        1       /* action must be taken immediately */
#define NGX_SYSLOG_CRIT         2       /* critical conditions */
#define NGX_SYSLOG_ERR          3       /* error conditions */
#define NGX_SYSLOG_WARNING      4       /* warning conditions */
#define NGX_SYSLOG_NOTICE       5       /* normal but significant condition */
#define NGX_SYSLOG_INFO         6       /* informational */
#define NGX_SYSLOG_DEBUG        7       /* debug-level messages */

#define NGX_SYSLOG_MAKEPRI(fac, pri)    (((fac) << 3) | (pri))

#define NGX_SYSLOG_INTERNAL_NOPRI       0x10    /* the "no priority" priority */


#define NGX_SYSLOG_INTERNAL_MARK                \
    NGX_SYSLOG_MAKEPRI(NGX_SYSLOG_NFACILITIES, 0)


typedef struct {
    char                       *name;
    ngx_int_t                   val;
} ngx_syslog_code;


/* facility codes */
#define NGX_SYSLOG_KERN         (0<<3)  /* kernel messages */
#define NGX_SYSLOG_USER         (1<<3)  /* random user-level messages */
#define NGX_SYSLOG_MAIL         (2<<3)  /* mail system */
#define NGX_SYSLOG_DAEMON       (3<<3)  /* system daemons */
#define NGX_SYSLOG_AUTH         (4<<3)  /* security/authorization messages */
#define NGX_SYSLOG_SYSLOG       (5<<3)  /* messages generated by syslogd */
#define NGX_SYSLOG_LPR          (6<<3)  /* line printer subsystem */
#define NGX_SYSLOG_NEWS         (7<<3)  /* network news subsystem */
#define NGX_SYSLOG_UUCP         (8<<3)  /* UUCP subsystem */
#define NGX_SYSLOG_CRON         (9<<3)  /* clock daemon */
#define NGX_SYSLOG_AUTHPRIV     (10<<3) /* security/authorization messages */
#define NGX_SYSLOG_FTP          (11<<3) /* ftp daemon */

#define NGX_SYSLOG_LOCAL0       (16<<3) /* reserved for local use */
#define NGX_SYSLOG_LOCAL1       (17<<3) /* reserved for local use */
#define NGX_SYSLOG_LOCAL2       (18<<3) /* reserved for local use */
#define NGX_SYSLOG_LOCAL3       (19<<3) /* reserved for local use */
#define NGX_SYSLOG_LOCAL4       (20<<3) /* reserved for local use */
#define NGX_SYSLOG_LOCAL5       (21<<3) /* reserved for local use */
#define NGX_SYSLOG_LOCAL6       (22<<3) /* reserved for local use */
#define NGX_SYSLOG_LOCAL7       (23<<3) /* reserved for local use */

#define NGX_SYSLOG_NFACILITIES  24      /* current number of facilities */


int ngx_write_syslog(ngx_syslog_t *task, u_char *buf, size_t len);
ngx_int_t ngx_log_set_syslog(ngx_pool_t *pool, ngx_str_t *value,
    ngx_log_t *log);


#endif /* _NGX_SYSLOG_H_INCLUDED_ */
