/*
 * Decompiled with CFR 0.152.
 */
package com.smartmarmot.orabbix;

import com.smartmarmot.common.SmartLogger;
import com.smartmarmot.common.db.DBConn;
import com.smartmarmot.common.db.DBJob;
import com.smartmarmot.orabbix.Configurator;
import com.smartmarmot.orabbix.Query;
import com.smartmarmot.orabbix.Querybox;
import com.smartmarmot.orabbix.Utility;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Hashtable;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;
import org.apache.log4j.Level;

public class Orabbixmon
implements Runnable {
    private boolean running = true;
    private boolean stopped = false;
    private static String configFile;

    public Orabbixmon(String _cfgfile) {
        try {
            configFile = _cfgfile;
            SmartLogger.logThis(Level.INFO, "Starting Orabbix Version 1.2.3 ");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void terminate() {
        this.running = false;
        while (!this.stopped) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Stopped");
    }

    @Override
    public void run() {
        try {
            Configurator cfg = null;
            try {
                cfg = new Configurator(configFile);
            }
            catch (Exception e) {
                SmartLogger.logThis(Level.ERROR, "Error while creating configurator with " + configFile + " " + e);
            }
            RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
            String pid = rmxb.getName();
            SmartLogger.logThis(Level.INFO, "Orabbix started with pid:" + pid.split("@")[0].toString());
            String pidfile = cfg.getPidFile();
            try {
                Utility.writePid(pid.split("@")[0].toString(), pidfile);
            }
            catch (Exception e) {
                SmartLogger.logThis(Level.ERROR, "Error while trying to write pidfile " + e);
            }
            Locale.setDefault(Locale.US);
            DBConn[] myDBConn = cfg.getConnections();
            if (myDBConn == null) {
                SmartLogger.logThis(Level.ERROR, "ERROR on main - Connections is null");
                throw new Exception("ERROR on main - Connections is null");
            }
            if (myDBConn.length == 0) {
                SmartLogger.logThis(Level.ERROR, "ERROR on main - Connections is empty");
                throw new Exception("ERROR on main - Connections is empty");
            }
            Integer maxThread = 0;
            try {
                maxThread = cfg.getMaxThread();
            }
            catch (Exception e) {
                SmartLogger.logThis(Level.WARN, "MaxThread not defined calculated maxThread = " + myDBConn.length * 3);
            }
            if (maxThread == null) {
                maxThread = 0;
            }
            if (maxThread == 0) {
                maxThread = myDBConn.length * 3;
            }
            ExecutorService executor = Executors.newFixedThreadPool(maxThread);
            Hashtable<String, Querybox> qbox = new Hashtable<String, Querybox>();
            for (int i = 0; i < myDBConn.length; ++i) {
                Querybox qboxtmp = Configurator.buildQueryBoxbyDBName(myDBConn[i].getName());
                qbox.put(myDBConn[i].getName(), qboxtmp);
            }
            cfg = null;
            while (this.running) {
                int i;
                Configurator c = new Configurator(configFile);
                if (!c.isEqualsDBList(myDBConn)) {
                    myDBConn = c.rebuildDBList(myDBConn);
                    for (i = 0; i < myDBConn.length; ++i) {
                        if (qbox.containsKey(myDBConn[i].getName())) continue;
                        Querybox qboxtmp = Configurator.buildQueryBoxbyDBName(myDBConn[i].getName());
                        qbox.put(myDBConn[i].getName(), qboxtmp);
                    }
                }
                for (i = 0; i < myDBConn.length; ++i) {
                    Querybox actqb = (Querybox)qbox.get(myDBConn[i].getName());
                    actqb.refresh();
                    Query[] q = actqb.getQueries();
                    SharedPoolDataSource spds = myDBConn[i].getSPDS();
                    Hashtable<String, Integer> zabbixServers = c.getZabbixServers();
                    SmartLogger.logThis(Level.DEBUG, "Ready to run DBJob for dbname ->" + myDBConn[i].getName());
                    DBJob runner = new DBJob(spds, q, "QueryList", zabbixServers, myDBConn[i].getName());
                    executor.execute(runner);
                }
                Thread.sleep(60000L);
                SmartLogger.logThis(Level.DEBUG, "Waking up Goood Morning");
            }
        }
        catch (Exception e1) {
            System.out.println("Stopping");
            e1.printStackTrace();
            this.stopped = true;
        }
    }
}

