/*
 * Decompiled with CFR 0.152.
 */
package com.orangefunction.tomcat.redissessions;

import com.orangefunction.tomcat.redissessions.RedisSession;
import com.orangefunction.tomcat.redissessions.Serializer;
import com.orangefunction.tomcat.redissessions.SessionSerializationMetadata;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JavaSerializer
implements Serializer {
    private ClassLoader loader;
    private final Log log = LogFactory.getLog(JavaSerializer.class);

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public byte[] attributesHashFrom(RedisSession session) throws IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration enumerator = session.getAttributeNames();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            attributes.put(key, session.getAttribute(key));
        }
        byte[] serialized = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(bos));){
            oos.writeUnshared(attributes);
            oos.flush();
            serialized = bos.toByteArray();
        }
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)"Unable to get MessageDigest instance for MD5");
        }
        return digester.digest(serialized);
    }

    @Override
    public byte[] serializeFrom(RedisSession session, SessionSerializationMetadata metadata) throws IOException {
        byte[] serialized = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(bos));){
            oos.writeObject(metadata);
            session.writeObjectData(oos);
            oos.flush();
            serialized = bos.toByteArray();
        }
        return serialized;
    }

    @Override
    public void deserializeInto(byte[] data, RedisSession session, SessionSerializationMetadata metadata) throws IOException, ClassNotFoundException {
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(data));
             CustomObjectInputStream ois = new CustomObjectInputStream((InputStream)bis, this.loader);){
            SessionSerializationMetadata serializedMetadata = (SessionSerializationMetadata)ois.readObject();
            metadata.copyFieldsFrom(serializedMetadata);
            session.readObjectData((ObjectInputStream)ois);
        }
    }
}

