/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle;

import org.dbsyncer.connector.oracle.cdc.DqlOracleListener;
import org.dbsyncer.connector.oracle.validator.DqlOracleConfigValidator;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDQLConnector;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.PageSql;

public final class DQLOracleConnector
extends AbstractDQLConnector {
    private final String TYPE = "DqlOracle";
    private final DqlOracleConfigValidator configValidator = new DqlOracleConfigValidator();

    public String getConnectorType() {
        return "DqlOracle";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        if (ListenerTypeEnum.isLog((String)listenerType)) {
            return new DqlOracleListener();
        }
        return null;
    }

    public String getPageSql(PageSql config) {
        return "SELECT * FROM (SELECT A.*, ROWNUM RN FROM (" + config.getQuerySql() + ")A WHERE ROWNUM <= ?) WHERE RN > ?";
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        int pageIndex = config.getPageIndex();
        return new Object[]{pageIndex * pageSize, (pageIndex - 1) * pageSize};
    }

    public String buildSqlWithQuotation() {
        return "\"";
    }

    public String getValidationQuery() {
        return "select 1 from dual";
    }
}

