/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.dbsyncer.biz.UserConfigService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.SHA1Util;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.model.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
public class WebAppConfig
extends WebSecurityConfigurerAdapter
implements AuthenticationProvider,
HttpSessionListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String LOGIN = "/login";
    private static final String LOGIN_PAGE = "/login.html";
    private static final int MAXIMUM_SESSIONS = 1;
    @Resource
    private UserConfigService userConfigService;

    @Bean
    public AuthenticationFailureHandler loginFailHandler() {
        return (request, response, e) -> this.write(response, RestResult.restFail((Object)e.getMessage(), (int)401));
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler loginSuccessHandler() {
        return new SavedRequestAwareAuthenticationSuccessHandler(){

            public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
                String msg = String.format("%s \u767b\u5f55\u6210\u529f!", authentication.getPrincipal());
                WebAppConfig.this.write(response, RestResult.restSuccess((Object)msg));
                this.logger.info((Object)msg);
            }
        };
    }

    @Bean
    public LogoutSuccessHandler logoutHandler() {
        return (request, response, authentication) -> {
            try {
                String msg = String.format("%s \u6ce8\u9500\u6210\u529f!", authentication.getPrincipal());
                this.write(response, RestResult.restSuccess((Object)msg));
                this.logger.info(msg);
            }
            catch (Exception e) {
                this.write(response, RestResult.restFail((Object)e.getMessage(), (int)403));
                this.logger.info("\u6ce8\u9500\u5931\u8d25: {}", (Object)e.getMessage());
            }
        };
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/css/**", "/js/**", "/img/**", "/config/**", "/plugins/**", "/index/version.json"})).permitAll().anyRequest()).authenticated().and()).formLogin().loginProcessingUrl(LOGIN)).loginPage(LOGIN_PAGE).successHandler((AuthenticationSuccessHandler)this.loginSuccessHandler())).failureHandler(this.loginFailHandler())).permitAll()).and()).logout().permitAll().invalidateHttpSession(true).deleteCookies(new String[]{"JSESSIONID"}).logoutSuccessHandler(this.logoutHandler()).and()).sessionManagement().sessionFixation().migrateSession().maximumSessions(1);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        password = SHA1Util.b64_sha1((String)password);
        UserInfo userInfo = this.userConfigService.getUserInfo(username);
        if (null == userInfo || !StringUtil.equals((CharSequence)userInfo.getPassword(), (CharSequence)password)) {
            throw new BadCredentialsException("\u5bf9\u4e0d\u8d77,\u60a8\u8f93\u5165\u7684\u5e10\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)userInfo.getRoleCode());
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, (Collection)authorities);
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.logger.debug("\u521b\u5efa\u4f1a\u8bdd:{}", (Object)se.getSession().getId());
        int maxInactiveInterval = se.getSession().getMaxInactiveInterval();
        this.logger.debug(String.valueOf(maxInactiveInterval));
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.logger.debug("\u9500\u6bc1\u4f1a\u8bdd:{}", (Object)se.getSession().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HttpServletResponse response, RestResult result) {
        PrintWriter out = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            response.setStatus(result.getStatus());
            out = response.getWriter();
            out.write(JsonUtil.objToJson((Object)result));
            out.flush();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }
}

