/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.index;

import javax.annotation.Resource;
import org.dbsyncer.biz.ProjectGroupService;
import org.dbsyncer.biz.vo.ProjectGroupVo;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.biz.vo.VersionVo;
import org.dbsyncer.common.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/index"})
public class IndexController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ProjectGroupService projectGroupService;
    @Resource
    private AppConfig appConfig;

    @GetMapping(value={""})
    public String index(ModelMap model, String projectGroupId) {
        try {
            ProjectGroupVo projectGroup = this.projectGroupService.getProjectGroup(projectGroupId);
            model.put((Object)"connectorSize", (Object)projectGroup.getConnectorSize());
            model.put((Object)"connectors", (Object)projectGroup.getConnectors());
            model.put((Object)"mappings", (Object)projectGroup.getMappings());
            model.put((Object)"projectGroupId", (Object)projectGroupId);
            model.put((Object)"projectGroups", (Object)this.projectGroupService.getProjectGroupAll());
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        return "index/index.html";
    }

    @GetMapping(value={"/version.json"})
    @ResponseBody
    public RestResult version() {
        return RestResult.restSuccess((Object)new VersionVo(this.appConfig.getName(), this.appConfig.getCopyright()));
    }
}

