/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.index;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.dbsyncer.biz.ConnectorService;
import org.dbsyncer.biz.MappingService;
import org.dbsyncer.biz.TableGroupService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.web.controller.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mapping"})
public class MappingController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ConnectorService connectorService;
    @Resource
    private MappingService mappingService;
    @Resource
    private TableGroupService tableGroupService;

    @GetMapping(value={"/pageAdd"})
    public String page(ModelMap model) {
        model.put((Object)"connectors", (Object)this.connectorService.getConnectorAll());
        return "mapping/add";
    }

    @GetMapping(value={"/page/{page}"})
    public String page(ModelMap model, @PathVariable(value="page") String page, @RequestParam(value="id") String id) {
        model.put((Object)"mapping", (Object)this.mappingService.getMapping(id));
        model.put((Object)"tableGroups", (Object)this.tableGroupService.getTableGroupAll(id));
        this.initConfig(model);
        return "mapping/" + page;
    }

    @PostMapping(value={"/copy"})
    @ResponseBody
    public RestResult add(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.mappingService.copy(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/add"})
    @ResponseBody
    public RestResult add(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.mappingService.add(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/edit"})
    @ResponseBody
    public RestResult edit(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.mappingService.edit(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/remove"})
    @ResponseBody
    public RestResult remove(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.mappingService.remove(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/start"})
    @ResponseBody
    public RestResult start(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.mappingService.start(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/stop"})
    @ResponseBody
    public RestResult stop(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.mappingService.stop(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/get"})
    @ResponseBody
    public RestResult get(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.mappingService.getMapping(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/getAll"})
    @ResponseBody
    public RestResult getAll() {
        try {
            return RestResult.restSuccess((Object)this.mappingService.getMappingAll());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/refreshTables"})
    @ResponseBody
    public RestResult refreshTables(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.mappingService.refreshMappingTables(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }
}

