/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.kafka;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private KafkaConsumer consumer;
    private KafkaProducer producer;
    private NetworkClient networkClient;

    public KafkaClient(KafkaConsumer consumer, KafkaProducer producer) {
        this.consumer = consumer;
        this.producer = producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() {
        if (null == this.networkClient) {
            KafkaClient kafkaClient = this;
            synchronized (kafkaClient) {
                if (null == this.networkClient) {
                    try {
                        this.networkClient = (NetworkClient)this.invoke(this.invoke(this.consumer, "client"), "client");
                    }
                    catch (NoSuchFieldException e) {
                        this.logger.error(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        this.logger.error(e.getMessage());
                    }
                }
            }
        }
        Node node = this.networkClient.leastLoadedNode(0L);
        this.telnet(node.host(), node.port(), 5000);
        return true;
    }

    private boolean telnet(String host, int port, int timeout) {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = socket.isConnected();
            return bl;
        }
        catch (IOException e) {
            throw new KafkaException(String.format("DNS resolution failed for url in %s %s:%s", "bootstrap.servers", host, port));
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Object invoke(Object obj, String declaredFieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(declaredFieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    public void close() {
        if (null != this.producer) {
            this.producer.close();
        }
        if (null != this.consumer) {
            this.consumer.close();
        }
    }

    public void subscribe(List<String> topics) {
        this.consumer.subscribe(topics);
    }

    public ConsumerRecords<String, Object> poll(long timeout) {
        return this.consumer.poll(timeout);
    }

    public void send(String topic, String key, Map<String, Object> map) {
        this.producer.send(new ProducerRecord(topic, (Object)key, map));
    }
}

