/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.connector.kafka.KafkaConnectorInstance;
import org.dbsyncer.connector.kafka.config.KafkaConfig;
import org.dbsyncer.connector.kafka.validator.KafkaConfigValidator;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.connector.AbstractConnector;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConnector
extends AbstractConnector
implements ConnectorService<KafkaConnectorInstance, KafkaConfig> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String TYPE = "Kafka";
    private final KafkaConfigValidator configValidator = new KafkaConfigValidator();

    public String getConnectorType() {
        return "Kafka";
    }

    public boolean isSupportedTiming() {
        return false;
    }

    public boolean isSupportedLog() {
        return false;
    }

    public Class<KafkaConfig> getConfigClass() {
        return KafkaConfig.class;
    }

    public ConnectorInstance connect(KafkaConfig config) {
        return new KafkaConnectorInstance(config);
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public void disconnect(KafkaConnectorInstance connectorInstance) {
        connectorInstance.close();
    }

    public boolean isAlive(KafkaConnectorInstance connectorInstance) {
        return connectorInstance.getConnection().ping();
    }

    public String getConnectorInstanceCacheKey(KafkaConfig config) {
        return String.format("%s-%s-%s-%s", config.getConnectorType(), config.getBootstrapServers(), config.getTopic(), config.getGroupId());
    }

    public List<Table> getTable(KafkaConnectorInstance connectorInstance) {
        ArrayList<Table> topics = new ArrayList<Table>();
        topics.add(new Table(connectorInstance.getConfig().getTopic()));
        return topics;
    }

    public MetaInfo getMetaInfo(KafkaConnectorInstance connectorInstance, String tableName) {
        KafkaConfig config = connectorInstance.getConfig();
        List fields = JsonUtil.jsonToArray((String)config.getFields(), Field.class);
        return new MetaInfo().setColumn(fields);
    }

    public long getCount(KafkaConnectorInstance connectorInstance, Map<String, String> command) {
        return 0L;
    }

    public Result reader(KafkaConnectorInstance connectorInstance, ReaderConfig config) {
        throw new KafkaException("Full synchronization is not supported");
    }

    public Result writer(KafkaConnectorInstance connectorInstance, WriterBatchConfig config) {
        List data = config.getData();
        if (CollectionUtils.isEmpty((Collection)data) || CollectionUtils.isEmpty((Collection)config.getFields())) {
            this.logger.error("writer data can not be empty.");
            throw new KafkaException("writer data can not be empty.");
        }
        Result result = new Result();
        KafkaConfig cfg = connectorInstance.getConfig();
        List pkFields = PrimaryKeyUtil.findConfigPrimaryKeyFields((WriterBatchConfig)config);
        try {
            String topic = cfg.getTopic();
            String pk = ((Field)pkFields.get(0)).getName();
            data.forEach(row -> connectorInstance.getConnection().send(topic, String.valueOf(row.get(pk)), (Map<String, Object>)row));
            result.addSuccessData(data);
        }
        catch (Exception e) {
            result.addFailData(data);
            result.getError().append(e.getMessage()).append(System.lineSeparator());
            this.logger.error(e.getMessage());
        }
        return result;
    }

    public Map<String, String> getSourceCommand(CommandConfig commandConfig) {
        return Collections.EMPTY_MAP;
    }

    public Map<String, String> getTargetCommand(CommandConfig commandConfig) {
        return Collections.EMPTY_MAP;
    }

    public Listener getListener(String listenerType) {
        return null;
    }
}

