/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.kafka.util;

import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.dbsyncer.connector.kafka.KafkaClient;
import org.dbsyncer.connector.kafka.config.KafkaConfig;

public abstract class KafkaUtil {
    public static KafkaClient getConnection(KafkaConfig config) {
        Properties props = new Properties();
        props.put("bootstrap.servers", config.getBootstrapServers());
        props.put("group.id", config.getGroupId());
        props.put("enable.auto.commit", (Object)true);
        props.put("auto.commit.interval.ms", (Object)5000);
        props.put("session.timeout.ms", (Object)config.getSessionTimeoutMs());
        props.put("max.partition.fetch.bytes", (Object)config.getMaxPartitionFetchBytes());
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", config.getDeserializer());
        KafkaConsumer consumer = new KafkaConsumer(props);
        Properties props2 = new Properties();
        props2.put("bootstrap.servers", config.getBootstrapServers());
        props2.put("buffer.memory", (Object)config.getBufferMemory());
        props2.put("batch.size", (Object)config.getBatchSize());
        props2.put("linger.ms", (Object)config.getLingerMs());
        props2.put("acks", config.getAcks());
        props2.put("retries", (Object)config.getRetries());
        props2.put("max.block.ms", (Object)60000);
        props2.put("max.request.size", (Object)config.getMaxRequestSize());
        props2.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props2.put("value.serializer", config.getSerializer());
        KafkaProducer producer = new KafkaProducer(props2);
        return new KafkaClient(consumer, producer);
    }

    public static void close(KafkaClient client) {
        if (null != client) {
            client.close();
        }
    }
}

