/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.plugin.impl;

import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.dbsyncer.common.config.AppConfig;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.plugin.NotifyService;
import org.dbsyncer.plugin.model.NotifyMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@ConditionalOnProperty(value={"dbsyncer.plugin.notify.mail.enabled"}, havingValue="true")
@ConfigurationProperties(prefix="dbsyncer.plugin.notify.mail")
public final class MailNotifyServiceProvider
implements NotifyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private AppConfig appConfig;
    private String username;
    private String password;
    private Session session;

    @PostConstruct
    private void init() {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.host", "smtp.qq.com");
        props.put("mail.user", this.username);
        props.put("mail.password", this.password);
        this.session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailNotifyServiceProvider.this.username, MailNotifyServiceProvider.this.password);
            }
        });
    }

    @Override
    public void sendMessage(NotifyMessage notifyMessage) {
        try {
            this.checkMail(notifyMessage);
            String title = String.format("\u3010%s\u901a\u77e5\u3011%s", this.appConfig.getName(), notifyMessage.getTitle());
            String content = this.createTemplate(this.appConfig.getName(), notifyMessage.getContent());
            MimeMessage message = new MimeMessage(this.session);
            message.setFrom((Address)new InternetAddress(this.username));
            List<String> messageReceivers = notifyMessage.getReceivers();
            int size = messageReceivers.size();
            InternetAddress[] addresses = new InternetAddress[size];
            for (int i = 0; i < size; ++i) {
                addresses[i] = new InternetAddress(messageReceivers.get(i));
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])addresses);
            message.setSubject(title);
            message.setContent((Object)content, "text/html;charset=UTF-8");
            Transport.send((Message)message);
            this.logger.info("simple mail send success");
        }
        catch (Exception e) {
            this.logger.error("simple mail send error!", (Throwable)e);
        }
    }

    private String createTemplate(String appName, String content) {
        String temp = "<!DOCTYPE html>\n<html lang=\"en\">\n<meta charset=\"UTF-8\">\n<title>${appName}\u901a\u77e5</title>\n</head>\n<body>\n${content}\n<p><a href=\"http://gitee.com/ghi/dbsyncer\">\u8bbf\u95ee\u9879\u76ee</a></p>\n</body>\n</html>";
        String replace = StringUtil.replace((String)temp, (String)"${appName}", (String)appName);
        replace = StringUtil.replace((String)replace, (String)"${content}", (String)content);
        return replace;
    }

    private void checkMail(NotifyMessage notifyMessage) {
        Assert.notNull((Object)notifyMessage, (String)"\u901a\u77e5\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)notifyMessage.getTitle(), (String)"\u90ae\u4ef6\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)notifyMessage.getContent(), (String)"\u90ae\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(notifyMessage.getReceivers(), (String)"\u90ae\u4ef6\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

