/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.base;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.connector.base.ConnectorException;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.DDLConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.connector.AbstractConnector;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ConnectorFactory
implements DisposableBean {
    private final Map<String, ConnectorInstance> pool = new ConcurrentHashMap<String, ConnectorInstance>();
    private final Map<String, ConnectorService> service = new ConcurrentHashMap<String, ConnectorService>();
    private final Set<String> connectorTypes = new HashSet<String>();

    @PostConstruct
    private void init() {
        ServiceLoader<ConnectorService> services = ServiceLoader.load(ConnectorService.class, Thread.currentThread().getContextClassLoader());
        for (ConnectorService s : services) {
            this.service.putIfAbsent(s.getConnectorType(), s);
            this.connectorTypes.add(s.getConnectorType());
        }
    }

    public void destroy() {
        this.pool.values().forEach(this::disconnect);
        this.pool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorInstance connect(ConnectorConfig config) {
        Assert.notNull((Object)config, (String)"ConnectorConfig can not be null.");
        ConnectorService connectorService = this.getConnectorService(config);
        String cacheKey = connectorService.getConnectorInstanceCacheKey(config);
        if (!this.pool.containsKey(cacheKey)) {
            Map<String, ConnectorInstance> map = this.pool;
            synchronized (map) {
                if (!this.pool.containsKey(cacheKey)) {
                    ConnectorInstance instance = connectorService.connect(config);
                    Assert.isTrue((boolean)connectorService.isAlive(instance), (String)"\u8fde\u63a5\u914d\u7f6e\u5f02\u5e38");
                    this.pool.putIfAbsent(cacheKey, instance);
                }
            }
        }
        try {
            ConnectorInstance connectorInstance = this.pool.get(cacheKey);
            ConnectorInstance clone = (ConnectorInstance)connectorInstance.clone();
            clone.setConfig(config);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new ConnectorException(e);
        }
    }

    public Listener getListener(String connectorType, String listenerType) {
        return this.getConnectorService(connectorType).getListener(listenerType);
    }

    public boolean isAlive(ConnectorConfig config) {
        Assert.notNull((Object)config, (String)"ConnectorConfig can not be null.");
        ConnectorService connectorService = this.getConnectorService(config);
        String cacheKey = connectorService.getConnectorInstanceCacheKey(config);
        if (this.pool.containsKey(cacheKey)) {
            return connectorService.isAlive(this.pool.get(cacheKey));
        }
        return false;
    }

    public List<Table> getTable(ConnectorInstance connectorInstance) {
        Assert.notNull((Object)connectorInstance, (String)"ConnectorInstance can not be null.");
        List tableList = this.getConnectorService(connectorInstance.getConfig()).getTable(connectorInstance);
        Collections.sort(tableList, Comparator.comparing(Table::getName));
        return tableList;
    }

    public MetaInfo getMetaInfo(ConnectorInstance connectorInstance, String tableName) {
        Assert.notNull((Object)connectorInstance, (String)"ConnectorInstance can not be null.");
        Assert.hasText((String)tableName, (String)"tableName can not be empty.");
        return this.getConnectorService(connectorInstance.getConfig()).getMetaInfo(connectorInstance, tableName);
    }

    public Map<String, String> getCommand(CommandConfig sourceCommandConfig, CommandConfig targetCommandConfig) {
        Map tCmd;
        Assert.notNull((Object)sourceCommandConfig, (String)"SourceCommandConfig can not be null.");
        Assert.notNull((Object)targetCommandConfig, (String)"TargetCommandConfig can not be null.");
        HashMap<String, String> map = new HashMap<String, String>();
        Map sCmd = this.getConnectorService(sourceCommandConfig.getConnectorType()).getSourceCommand(sourceCommandConfig);
        if (!CollectionUtils.isEmpty((Map)sCmd)) {
            map.putAll(sCmd);
        }
        if (!CollectionUtils.isEmpty((Map)(tCmd = this.getConnectorService(targetCommandConfig.getConnectorType()).getTargetCommand(targetCommandConfig)))) {
            map.putAll(tCmd);
        }
        return map;
    }

    public long getCount(ConnectorInstance connectorInstance, Map<String, String> command) {
        Assert.notNull((Object)connectorInstance, (String)"ConnectorInstance can not null");
        Assert.notNull(command, (String)"command can not null");
        return this.getConnectorService(connectorInstance.getConfig()).getCount(connectorInstance, command);
    }

    public Result reader(ConnectorInstance connectorInstance, ReaderConfig config) {
        Assert.notNull((Object)connectorInstance, (String)"ConnectorInstance can not null");
        Assert.notNull((Object)config, (String)"ReaderConfig can not null");
        Result result = this.getConnectorService(connectorInstance.getConfig()).reader(connectorInstance, config);
        Assert.notNull((Object)result, (String)"Connector reader result can not null");
        return result;
    }

    public Result writer(ConnectorInstance connectorInstance, WriterBatchConfig config) {
        Assert.notNull((Object)connectorInstance, (String)"ConnectorInstance can not null");
        Assert.notNull((Object)config, (String)"WriterBatchConfig can not null");
        ConnectorService connector = this.getConnectorService(connectorInstance.getConfig());
        if (connector instanceof AbstractConnector) {
            AbstractConnector conn = (AbstractConnector)connector;
            try {
                conn.convertProcessBeforeWriter(connectorInstance, config);
            }
            catch (Exception e) {
                Result result = new Result();
                result.getError().append(e.getMessage());
                result.addFailData(config.getData());
                return result;
            }
        }
        Result result = connector.writer(connectorInstance, config);
        Assert.notNull((Object)result, (String)"Connector writer batch result can not null");
        return result;
    }

    public Result writerDDL(ConnectorInstance connectorInstance, DDLConfig ddlConfig) {
        Assert.notNull((Object)connectorInstance, (String)"ConnectorInstance can not null");
        Result result = this.getConnectorService(connectorInstance.getConfig()).writerDDL(connectorInstance, ddlConfig);
        Assert.notNull((Object)result, (String)"Connector writer batch result can not null");
        return result;
    }

    public ConnectorService getConnectorService(ConnectorConfig connectorConfig) {
        Assert.notNull((Object)connectorConfig, (String)"ConnectorConfig can not null");
        return this.getConnectorService(connectorConfig.getConnectorType());
    }

    public ConnectorService getConnectorService(String connectorType) {
        ConnectorService connectorService = this.service.get(connectorType);
        if (connectorService == null) {
            Assert.isTrue((boolean)false, (String)("Unsupported connector type:" + connectorType));
        }
        return connectorService;
    }

    public Set<String> getConnectorTypeAll() {
        return this.connectorTypes;
    }

    public void disconnect(ConnectorConfig config) {
        Assert.notNull((Object)config, (String)"ConnectorConfig can not be null.");
        String cacheKey = this.getConnectorService(config).getConnectorInstanceCacheKey(config);
        ConnectorInstance connectorInstance = this.pool.get(cacheKey);
        if (connectorInstance != null) {
            this.disconnect(connectorInstance);
            this.pool.remove(cacheKey);
        }
    }

    private void disconnect(ConnectorInstance connectorInstance) {
        Assert.notNull((Object)connectorInstance, (String)"ConnectorInstance can not be null.");
        this.getConnectorService(connectorInstance.getConfig()).disconnect(connectorInstance);
    }
}

