/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.transport.Transport;

interface SearchPhaseContext
extends Executor {
    public int getNumShards();

    public Logger getLogger();

    public SearchTask getTask();

    public SearchRequest getRequest();

    public boolean isPartOfPointInTime(ShardSearchContextId var1);

    public void sendSearchResponse(InternalSearchResponse var1, AtomicArray<SearchPhaseResult> var2);

    public void onFailure(Exception var1);

    public void onPhaseFailure(SearchPhase var1, String var2, Throwable var3);

    public void onShardFailure(int var1, @Nullable SearchShardTarget var2, Exception var3);

    public Transport.Connection getConnection(String var1, String var2);

    public SearchTransportService getSearchTransport();

    default public void sendReleaseSearchContext(ShardSearchContextId contextId, Transport.Connection connection, OriginalIndices originalIndices) {
        if (!1.$assertionsDisabled && this.isPartOfPointInTime(contextId)) {
            throw new AssertionError((Object)("Must not release point in time context [" + contextId + "]"));
        }
        if (connection != null) {
            this.getSearchTransport().sendFreeContext(connection, contextId, originalIndices);
        }
    }

    public ShardSearchRequest buildShardSearchRequest(SearchShardIterator var1, int var2);

    public void executeNextPhase(SearchPhase var1, SearchPhase var2);

    public void addReleasable(Releasable var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

