/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TransportActionNodeProxy;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.transport.TransportService;

final class TransportProxyClient {
    private final TransportClientNodesService nodesService;
    private final Map<ActionType, TransportActionNodeProxy> proxies;

    TransportProxyClient(TransportService transportService, TransportClientNodesService nodesService, List<ActionType> actions) {
        this.nodesService = nodesService;
        HashMap proxies = new HashMap();
        for (ActionType action : actions) {
            proxies.put(action, new TransportActionNodeProxy(action, transportService));
        }
        this.proxies = Collections.unmodifiableMap(proxies);
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response>> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        TransportActionNodeProxy proxy = this.proxies.get(action);
        assert (proxy != null) : "no proxy found for action: " + action;
        this.nodesService.execute((n, l) -> proxy.execute(n, request, l), listener);
    }
}

