/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.DocValueFormat;

public interface LeafFieldData
extends Accountable,
Releasable {
    public ScriptDocValues<?> getScriptValues();

    public SortedBinaryDocValues getBytesValues();

    default public FormattedDocValues getFormattedValues(final DocValueFormat format) {
        final SortedBinaryDocValues values = this.getBytesValues();
        return new FormattedDocValues(){

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return values.advanceExact(docId);
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public Object nextValue() throws IOException {
                return format.format(values.nextValue());
            }
        };
    }
}

