/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.BooleanFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RuntimeFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;

final class DynamicFieldsBuilder {
    private static final Concrete CONCRETE = new Concrete(DocumentParser::parseObjectOrField);
    static final DynamicFieldsBuilder DYNAMIC_TRUE = new DynamicFieldsBuilder(CONCRETE);
    static final DynamicFieldsBuilder DYNAMIC_RUNTIME = new DynamicFieldsBuilder(new Runtime());
    private final Strategy strategy;

    private DynamicFieldsBuilder(Strategy strategy) {
        this.strategy = strategy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createDynamicFieldFromValue(ParseContext context, XContentParser.Token token, String name) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            String text = context.parser().text();
            boolean parseableAsLong = false;
            try {
                Long.parseLong(text);
                parseableAsLong = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean parseableAsDouble = false;
            try {
                Double.parseDouble(text);
                parseableAsDouble = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (parseableAsLong && context.root().numericDetection()) {
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.LONG, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicLongField(context, name)));
                return;
            }
            if (parseableAsDouble && context.root().numericDetection()) {
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DOUBLE, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDoubleField(context, name)));
                return;
            }
            if (!parseableAsLong && !parseableAsDouble && context.root().dateDetection()) {
                for (DateFormatter dateTimeFormatter : context.root().dynamicDateTimeFormatters()) {
                    try {
                        dateTimeFormatter.parse(text);
                    }
                    catch (IllegalArgumentException | DateTimeParseException | ElasticsearchParseException e) {
                        continue;
                    }
                    DynamicFieldsBuilder.createDynamicDateField(context, name, dateTimeFormatter, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDateField(context, name, dateTimeFormatter)));
                    return;
                }
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicStringField(context, name)));
                return;
            }
            DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicStringField(context, name)));
            return;
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = context.parser().numberType();
            if (numberType == XContentParser.NumberType.INT || numberType == XContentParser.NumberType.LONG || numberType == XContentParser.NumberType.BIG_INTEGER) {
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.LONG, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicLongField(context, name)));
                return;
            } else {
                if (numberType != XContentParser.NumberType.FLOAT && numberType != XContentParser.NumberType.DOUBLE && numberType != XContentParser.NumberType.BIG_DECIMAL) throw new IllegalStateException("Unable to parse number of type [" + numberType + "]");
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DOUBLE, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDoubleField(context, name)));
            }
            return;
        } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
            DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.BOOLEAN, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicBooleanField(context, name)));
            return;
        } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
            DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.BINARY, (CheckedRunnable<IOException>)((CheckedRunnable)() -> CONCRETE.newDynamicBinaryField(context, name)));
            return;
        } else {
            this.createDynamicStringFieldFromTemplate(context, name);
        }
    }

    Mapper createDynamicObjectMapper(ParseContext context, String name) {
        Mapper mapper = this.createObjectMapperFromTemplate(context, name);
        return mapper != null ? mapper : new ObjectMapper.Builder(name, context.indexSettings().getIndexVersionCreated()).enabled(true).build(context.path());
    }

    Mapper createObjectMapperFromTemplate(ParseContext context, String name) {
        Mapper.Builder templateBuilder = DynamicFieldsBuilder.findTemplateBuilderForObject(context, name);
        return templateBuilder == null ? null : templateBuilder.build(context.path());
    }

    void createDynamicStringFieldFromTemplate(ParseContext context, String name) throws IOException {
        DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {}));
    }

    private static void createDynamicDateField(ParseContext context, String name, DateFormatter dateFormatter, CheckedRunnable<IOException> createDynamicField) throws IOException {
        DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DATE, dateFormatter, createDynamicField);
    }

    private static void createDynamicField(ParseContext context, String name, DynamicTemplate.XContentFieldType matchType, CheckedRunnable<IOException> dynamicFieldStrategy) throws IOException {
        assert (matchType != DynamicTemplate.XContentFieldType.DATE);
        DynamicFieldsBuilder.createDynamicField(context, name, matchType, null, dynamicFieldStrategy);
    }

    private static void createDynamicField(ParseContext context, String name, DynamicTemplate.XContentFieldType matchType, DateFormatter dateFormatter, CheckedRunnable<IOException> dynamicFieldStrategy) throws IOException {
        if (!DynamicFieldsBuilder.applyMatchingTemplate(context, name, matchType, dateFormatter)) {
            dynamicFieldStrategy.run();
        }
    }

    private static boolean applyMatchingTemplate(ParseContext context, String name, DynamicTemplate.XContentFieldType matchType, DateFormatter dateFormatter) throws IOException {
        DynamicTemplate dynamicTemplate = context.root().findTemplate(context.path(), name, matchType);
        if (dynamicTemplate == null) {
            return false;
        }
        String dynamicType = dynamicTemplate.isRuntimeMapping() ? matchType.defaultRuntimeMappingType() : matchType.defaultMappingType();
        String mappingType = dynamicTemplate.mappingType(dynamicType);
        Map<String, Object> mapping = dynamicTemplate.mappingForName(name, dynamicType);
        if (dynamicTemplate.isRuntimeMapping()) {
            Mapper.TypeParser.ParserContext parserContext = context.parserContext(dateFormatter);
            RuntimeFieldType.Parser parser = parserContext.runtimeFieldTypeParser(mappingType);
            String fullName = context.path().pathAsText(name);
            if (parser == null) {
                throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + fullName + "]");
            }
            RuntimeFieldType runtimeFieldType = parser.parse(fullName, mapping, parserContext);
            Runtime.createDynamicField(runtimeFieldType, context);
        } else {
            Mapper.Builder builder = DynamicFieldsBuilder.parseDynamicTemplateMapping(name, mappingType, mapping, dateFormatter, context);
            CONCRETE.createDynamicField(builder, context);
        }
        return true;
    }

    private static Mapper.Builder findTemplateBuilderForObject(ParseContext context, String name) {
        DynamicTemplate.XContentFieldType matchType = DynamicTemplate.XContentFieldType.OBJECT;
        DynamicTemplate dynamicTemplate = context.root().findTemplate(context.path(), name, matchType);
        if (dynamicTemplate == null) {
            return null;
        }
        String dynamicType = matchType.defaultMappingType();
        String mappingType = dynamicTemplate.mappingType(dynamicType);
        Map<String, Object> mapping = dynamicTemplate.mappingForName(name, dynamicType);
        return DynamicFieldsBuilder.parseDynamicTemplateMapping(name, mappingType, mapping, null, context);
    }

    private static Mapper.Builder parseDynamicTemplateMapping(String name, String mappingType, Map<String, Object> mapping, DateFormatter dateFormatter, ParseContext context) {
        Mapper.TypeParser.ParserContext parserContext = context.parserContext(dateFormatter);
        Mapper.TypeParser typeParser = (parserContext = parserContext.createDynamicTemplateFieldContext(parserContext)).typeParser(mappingType);
        if (typeParser == null) {
            throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + name + "]");
        }
        return typeParser.parse(name, mapping, parserContext);
    }

    private static interface Strategy {
        public void newDynamicStringField(ParseContext var1, String var2) throws IOException;

        public void newDynamicLongField(ParseContext var1, String var2) throws IOException;

        public void newDynamicDoubleField(ParseContext var1, String var2) throws IOException;

        public void newDynamicBooleanField(ParseContext var1, String var2) throws IOException;

        public void newDynamicDateField(ParseContext var1, String var2, DateFormatter var3) throws IOException;
    }

    private static final class Runtime
    implements Strategy {
        private Runtime() {
        }

        static void createDynamicField(RuntimeFieldType runtimeFieldType, ParseContext context) {
            context.addDynamicRuntimeField(runtimeFieldType);
        }

        @Override
        public void newDynamicStringField(ParseContext context, String name) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicStringField(fullName);
            Runtime.createDynamicField(runtimeFieldType, context);
        }

        @Override
        public void newDynamicLongField(ParseContext context, String name) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicLongField(fullName);
            Runtime.createDynamicField(runtimeFieldType, context);
        }

        @Override
        public void newDynamicDoubleField(ParseContext context, String name) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicDoubleField(fullName);
            Runtime.createDynamicField(runtimeFieldType, context);
        }

        @Override
        public void newDynamicBooleanField(ParseContext context, String name) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicBooleanField(fullName);
            Runtime.createDynamicField(runtimeFieldType, context);
        }

        @Override
        public void newDynamicDateField(ParseContext context, String name, DateFormatter dateFormatter) {
            String fullName = context.path().pathAsText(name);
            RuntimeFieldType runtimeFieldType = context.getDynamicRuntimeFieldsBuilder().newDynamicDateField(fullName, dateFormatter);
            Runtime.createDynamicField(runtimeFieldType, context);
        }
    }

    private static final class Concrete
    implements Strategy {
        private final CheckedBiConsumer<ParseContext, Mapper, IOException> parseField;

        Concrete(CheckedBiConsumer<ParseContext, Mapper, IOException> parseField) {
            this.parseField = parseField;
        }

        void createDynamicField(Mapper.Builder builder, ParseContext context) throws IOException {
            Mapper mapper = builder.build(context.path());
            context.addDynamicMapper(mapper);
            this.parseField.accept(context, mapper);
        }

        @Override
        public void newDynamicStringField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new TextFieldMapper.Builder(name, context.indexAnalyzers()).addMultiField(new KeywordFieldMapper.Builder("keyword").ignoreAbove(256)), context);
        }

        @Override
        public void newDynamicLongField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.LONG, context.indexSettings().getSettings()), context);
        }

        @Override
        public void newDynamicDoubleField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.FLOAT, context.indexSettings().getSettings()), context);
        }

        @Override
        public void newDynamicBooleanField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new BooleanFieldMapper.Builder(name), context);
        }

        @Override
        public void newDynamicDateField(ParseContext context, String name, DateFormatter dateTimeFormatter) throws IOException {
            Settings settings = context.indexSettings().getSettings();
            boolean ignoreMalformed = FieldMapper.IGNORE_MALFORMED_SETTING.get(settings);
            this.createDynamicField(new DateFieldMapper.Builder(name, DateFieldMapper.Resolution.MILLISECONDS, dateTimeFormatter, ignoreMalformed, context.indexSettings().getIndexVersionCreated()), context);
        }

        void newDynamicBinaryField(ParseContext context, String name) throws IOException {
            this.createDynamicField(new BinaryFieldMapper.Builder(name), context);
        }
    }
}

