/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.tasks.TaskResultsService;

public class SystemIndices {
    private static final Map<String, Feature> SERVER_SYSTEM_INDEX_DESCRIPTORS = Collections.singletonMap("tasks", new Feature("Manages task results", Collections.singletonList(TaskResultsService.TASKS_DESCRIPTOR)));
    private final CharacterRunAutomaton runAutomaton;
    private final Map<String, Feature> featureDescriptors;

    public SystemIndices(Map<String, Feature> pluginAndModulesDescriptors) {
        this.featureDescriptors = SystemIndices.buildSystemIndexDescriptorMap(pluginAndModulesDescriptors);
        SystemIndices.checkForOverlappingPatterns(this.featureDescriptors);
        this.checkForDuplicateAliases(this.getSystemIndexDescriptors());
        this.runAutomaton = SystemIndices.buildCharacterRunAutomaton(this.featureDescriptors);
    }

    private void checkForDuplicateAliases(Collection<SystemIndexDescriptor> descriptors) {
        HashMap<String, Integer> aliasCounts = new HashMap<String, Integer>();
        for (SystemIndexDescriptor descriptor : descriptors) {
            String aliasName = descriptor.getAliasName();
            if (aliasName == null) continue;
            aliasCounts.compute(aliasName, (alias, existingCount) -> 1 + (existingCount == null ? 0 : existingCount));
        }
        List duplicateAliases = aliasCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        if (!duplicateAliases.isEmpty()) {
            throw new IllegalStateException("Found aliases associated with multiple system index descriptors: " + duplicateAliases + "");
        }
    }

    public boolean isSystemIndex(Index index) {
        return this.isSystemIndex(index.getName());
    }

    public boolean isSystemIndex(String indexName) {
        return this.runAutomaton.run(indexName);
    }

    @Nullable
    public SystemIndexDescriptor findMatchingDescriptor(String name) {
        List matchingDescriptors = this.featureDescriptors.values().stream().flatMap(feature -> feature.getIndexDescriptors().stream()).filter(descriptor -> descriptor.matchesIndexPattern(name)).collect(Collectors.toList());
        if (matchingDescriptors.isEmpty()) {
            return null;
        }
        if (matchingDescriptors.size() == 1) {
            return (SystemIndexDescriptor)matchingDescriptors.get(0);
        }
        StringBuilder errorMessage = new StringBuilder().append("index name [").append(name).append("] is claimed as a system index by multiple system index patterns: [").append(matchingDescriptors.stream().map(descriptor -> "pattern: [" + descriptor.getIndexPattern() + "], description: [" + descriptor.getDescription() + "]").collect(Collectors.joining("; ")));
        assert (false) : errorMessage.toString();
        throw new IllegalStateException(errorMessage.toString());
    }

    public Map<String, Feature> getFeatures() {
        return this.featureDescriptors;
    }

    private static CharacterRunAutomaton buildCharacterRunAutomaton(Map<String, Feature> descriptors) {
        Optional<Automaton> automaton = descriptors.values().stream().flatMap(feature -> feature.getIndexDescriptors().stream()).map(descriptor -> SystemIndexDescriptor.buildAutomaton(descriptor.getIndexPattern(), descriptor.getAliasName())).reduce(Operations::union);
        return new CharacterRunAutomaton(MinimizationOperations.minimize((Automaton)automaton.orElse(Automata.makeEmpty()), (int)Integer.MAX_VALUE));
    }

    static void checkForOverlappingPatterns(Map<String, Feature> sourceToDescriptors) {
        List<Tuple> sourceDescriptorPair = sourceToDescriptors.entrySet().stream().flatMap(entry -> ((Feature)entry.getValue()).getIndexDescriptors().stream().map(descriptor -> new Tuple((Object)((String)entry.getKey()), descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemIndexDescriptor)d.v2()).getIndexPattern())).collect(Collectors.toList());
        sourceDescriptorPair.forEach(descriptorToCheck -> {
            List descriptorsMatchingThisPattern = sourceDescriptorPair.stream().filter(d -> descriptorToCheck.v2() != d.v2()).filter(d -> SystemIndices.overlaps((SystemIndexDescriptor)descriptorToCheck.v2(), (SystemIndexDescriptor)d.v2())).collect(Collectors.toList());
            if (!descriptorsMatchingThisPattern.isEmpty()) {
                throw new IllegalStateException("a system index descriptor [" + descriptorToCheck.v2() + "] from [" + (String)descriptorToCheck.v1() + "] overlaps with other system index descriptors: [" + descriptorsMatchingThisPattern.stream().map(descriptor -> descriptor.v2() + " from [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
            }
        });
    }

    private static boolean overlaps(SystemIndexDescriptor a1, SystemIndexDescriptor a2) {
        Automaton a2Automaton;
        Automaton a1Automaton = SystemIndexDescriptor.buildAutomaton(a1.getIndexPattern(), null);
        return !Operations.isEmpty((Automaton)Operations.intersection((Automaton)a1Automaton, (Automaton)(a2Automaton = SystemIndexDescriptor.buildAutomaton(a2.getIndexPattern(), null))));
    }

    private static Map<String, Feature> buildSystemIndexDescriptorMap(Map<String, Feature> featuresMap) {
        HashMap<String, Feature> map = new HashMap<String, Feature>(featuresMap.size() + SERVER_SYSTEM_INDEX_DESCRIPTORS.size());
        map.putAll(featuresMap);
        SERVER_SYSTEM_INDEX_DESCRIPTORS.forEach((source, feature) -> {
            if (map.putIfAbsent((String)source, (Feature)feature) != null) {
                throw new IllegalArgumentException("plugin or module attempted to define the same source [" + source + "] as a built-in system index");
            }
        });
        return Collections.unmodifiableMap(map);
    }

    Collection<SystemIndexDescriptor> getSystemIndexDescriptors() {
        return this.featureDescriptors.values().stream().flatMap(f -> f.getIndexDescriptors().stream()).collect(Collectors.toList());
    }

    public static void validateFeatureName(String name, String plugin) {
        if ("none".equalsIgnoreCase(name)) {
            throw new IllegalArgumentException("feature name cannot be reserved name [\"none\"], but was for plugin [" + plugin + "]");
        }
    }

    public static class Feature {
        private final String description;
        private final Collection<SystemIndexDescriptor> indexDescriptors;
        private final Collection<String> associatedIndexPatterns;

        public Feature(String description, Collection<SystemIndexDescriptor> indexDescriptors, Collection<String> associatedIndexPatterns) {
            this.description = description;
            this.indexDescriptors = indexDescriptors;
            this.associatedIndexPatterns = associatedIndexPatterns;
        }

        public Feature(String description, Collection<SystemIndexDescriptor> indexDescriptors) {
            this(description, indexDescriptors, Collections.emptyList());
        }

        public String getDescription() {
            return this.description;
        }

        public Collection<SystemIndexDescriptor> getIndexDescriptors() {
            return this.indexDescriptors;
        }

        public Collection<String> getAssociatedIndexPatterns() {
            return this.associatedIndexPatterns;
        }
    }
}

