/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class HistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<HistogramAggregationBuilder> {
    public static final String NAME = "histogram";
    public static final ValuesSourceRegistry.RegistryKey<HistogramAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<HistogramAggregatorSupplier>("histogram", HistogramAggregatorSupplier.class);
    private static final ObjectParser<double[], Void> EXTENDED_BOUNDS_PARSER = new ObjectParser(Histogram.EXTENDED_BOUNDS_FIELD.getPreferredName(), () -> new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY});
    public static final ObjectParser<HistogramAggregationBuilder, String> PARSER;
    private double interval;
    private double offset = 0.0;
    private DoubleBounds extendedBounds;
    private DoubleBounds hardBounds;
    private BucketOrder order = BucketOrder.key(true);
    private boolean keyed = false;
    private long minDocCount = 0L;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        HistogramAggregatorFactory.registerAggregators(builder);
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    public HistogramAggregationBuilder(String name) {
        super(name);
    }

    protected HistogramAggregationBuilder(HistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.interval = clone.interval;
        this.offset = clone.offset;
        this.extendedBounds = clone.extendedBounds;
        this.hardBounds = clone.hardBounds;
        this.order = clone.order;
        this.keyed = clone.keyed;
        this.minDocCount = clone.minDocCount;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new HistogramAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public HistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readHistogramOrder(in, true);
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.interval = in.readDouble();
        this.offset = in.readDouble();
        if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.extendedBounds = in.readOptionalWriteable(DoubleBounds::new);
            this.hardBounds = in.readOptionalWriteable(DoubleBounds::new);
        } else {
            double minBound = in.readDouble();
            double maxBound = in.readDouble();
            this.extendedBounds = minBound == Double.POSITIVE_INFINITY && maxBound == Double.NEGATIVE_INFINITY ? null : new DoubleBounds(minBound, maxBound);
        }
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder(this.order, out, true);
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        out.writeDouble(this.interval);
        out.writeDouble(this.offset);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeOptionalWriteable(this.extendedBounds);
            out.writeOptionalWriteable(this.hardBounds);
        } else if (this.extendedBounds != null) {
            out.writeDouble(this.extendedBounds.getMin());
            out.writeDouble(this.extendedBounds.getMax());
        } else {
            out.writeDouble(Double.POSITIVE_INFINITY);
            out.writeDouble(Double.NEGATIVE_INFINITY);
        }
    }

    public double interval() {
        return this.interval;
    }

    public HistogramAggregationBuilder interval(double interval) {
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be >0 for histogram aggregation [" + this.name + "]");
        }
        this.interval = interval;
        return this;
    }

    public double offset() {
        return this.offset;
    }

    public HistogramAggregationBuilder offset(double offset) {
        this.offset = offset;
        return this;
    }

    public double minBound() {
        return DoubleBounds.getEffectiveMin(this.extendedBounds);
    }

    public double maxBound() {
        return DoubleBounds.getEffectiveMax(this.extendedBounds);
    }

    protected DoubleBounds extendedBounds() {
        return this.extendedBounds;
    }

    public HistogramAggregationBuilder extendedBounds(double minBound, double maxBound) {
        return this.extendedBounds(new DoubleBounds(minBound, maxBound));
    }

    public HistogramAggregationBuilder extendedBounds(DoubleBounds extendedBounds) {
        if (extendedBounds == null) {
            throw new IllegalArgumentException("[extended_bounds] must not be null: [" + this.name + "]");
        }
        this.extendedBounds = extendedBounds;
        return this;
    }

    public HistogramAggregationBuilder hardBounds(DoubleBounds hardBounds) {
        if (hardBounds == null) {
            throw new IllegalArgumentException("[hardBounds] must not be null: [" + this.name + "]");
        }
        this.hardBounds = hardBounds;
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public HistogramAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder(order) ? order : BucketOrder.compound(order);
        return this;
    }

    public HistogramAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public HistogramAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    public HistogramAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
        builder.field(Histogram.OFFSET_FIELD.getPreferredName(), this.offset);
        if (this.order != null) {
            builder.field(Histogram.ORDER_FIELD.getPreferredName());
            this.order.toXContent(builder, params);
        }
        builder.field(Histogram.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(Histogram.MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        if (this.extendedBounds != null) {
            builder.startObject(Histogram.EXTENDED_BOUNDS_FIELD.getPreferredName());
            this.extendedBounds.toXContent(builder, params);
            builder.endObject();
        }
        if (this.hardBounds != null) {
            builder.startObject(Histogram.HARD_BOUNDS_FIELD.getPreferredName());
            this.hardBounds.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        HistogramAggregatorSupplier aggregatorSupplier = context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        if (this.hardBounds != null && this.extendedBounds != null) {
            if (this.hardBounds.getMax() != null && this.extendedBounds.getMax() != null && this.hardBounds.getMax() < this.extendedBounds.getMax()) {
                throw new IllegalArgumentException("Extended bounds have to be inside hard bounds, hard bounds: [" + this.hardBounds + "], extended bounds: [" + this.extendedBounds.getMin() + "--" + this.extendedBounds.getMax() + "]");
            }
            if (this.hardBounds.getMin() != null && this.extendedBounds.getMin() != null && this.hardBounds.getMin() > this.extendedBounds.getMin()) {
                throw new IllegalArgumentException("Extended bounds have to be inside hard bounds, hard bounds: [" + this.hardBounds + "], extended bounds: [" + this.extendedBounds.getMin() + "--" + this.extendedBounds.getMax() + "]");
            }
        }
        return new HistogramAggregatorFactory(this.name, config, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, context, parent, subFactoriesBuilder, this.metadata, aggregatorSupplier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order, this.keyed, this.minDocCount, this.interval, this.offset, this.extendedBounds, this.hardBounds);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        HistogramAggregationBuilder other = (HistogramAggregationBuilder)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.interval, other.interval) && Objects.equals(this.offset, other.offset) && Objects.equals(this.extendedBounds, other.extendedBounds) && Objects.equals(this.hardBounds, other.hardBounds);
    }

    static {
        EXTENDED_BOUNDS_PARSER.declareDouble((bounds, d) -> {
            bounds[0] = d;
        }, new ParseField("min", new String[0]));
        EXTENDED_BOUNDS_PARSER.declareDouble((bounds, d) -> {
            bounds[1] = d;
        }, new ParseField("max", new String[0]));
        PARSER = ObjectParser.fromBuilder((String)NAME, HistogramAggregationBuilder::new);
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, false);
        PARSER.declareDouble(HistogramAggregationBuilder::interval, Histogram.INTERVAL_FIELD);
        PARSER.declareDouble(HistogramAggregationBuilder::offset, Histogram.OFFSET_FIELD);
        PARSER.declareBoolean(HistogramAggregationBuilder::keyed, Histogram.KEYED_FIELD);
        PARSER.declareLong(HistogramAggregationBuilder::minDocCount, Histogram.MIN_DOC_COUNT_FIELD);
        PARSER.declareField(HistogramAggregationBuilder::extendedBounds, parser -> (DoubleBounds)DoubleBounds.PARSER.apply(parser, null), Histogram.EXTENDED_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(HistogramAggregationBuilder::hardBounds, parser -> (DoubleBounds)DoubleBounds.PARSER.apply(parser, null), Histogram.HARD_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareObjectArray(HistogramAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam(p), Histogram.ORDER_FIELD);
    }
}

