/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLog;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.AbstractLinearCounting;

final class HyperLogLogPlusPlusSparse
extends AbstractHyperLogLogPlusPlus
implements Releasable {
    private final LinearCounting lc;

    HyperLogLogPlusPlusSparse(int precision, BigArrays bigArrays, long initialBuckets) {
        super(precision);
        this.lc = new LinearCounting(precision, bigArrays, initialBuckets);
    }

    @Override
    public long maxOrd() {
        return this.lc.sizes.size();
    }

    protected void ensureCapacity(long bucketOrd, long size) {
        this.lc.ensureCapacity(bucketOrd, size);
    }

    @Override
    public long cardinality(long bucketOrd) {
        return this.lc.cardinality(bucketOrd);
    }

    @Override
    protected boolean getAlgorithm(long bucketOrd) {
        return false;
    }

    @Override
    protected AbstractLinearCounting.HashesIterator getLinearCounting(long bucketOrd) {
        return this.lc.values(bucketOrd);
    }

    @Override
    protected AbstractHyperLogLog.RunLenIterator getHyperLogLog(long bucketOrd) {
        throw new IllegalArgumentException("Implementation does not support HLL structures");
    }

    @Override
    public void collect(long bucket, long hash) {
        this.lc.collect(bucket, hash);
    }

    @Override
    public void close() {
        Releasables.close((Releasable)this.lc);
    }

    protected void addEncoded(long bucket, int encoded) {
        this.lc.addEncoded(bucket, encoded);
    }

    private static class LinearCounting
    extends AbstractLinearCounting
    implements Releasable {
        private final BigArrays bigArrays;
        private final LinearCountingIterator iterator;
        private ObjectArray<IntArray> values;
        private IntArray sizes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        LinearCounting(int p, BigArrays bigArrays, long initialBuckets) {
            IntArray sizes;
            ObjectArray values;
            block3: {
                super(p);
                this.bigArrays = bigArrays;
                values = null;
                sizes = null;
                boolean success = false;
                try {
                    values = bigArrays.newObjectArray(initialBuckets);
                    sizes = bigArrays.newIntArray(initialBuckets);
                    success = true;
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close(values, sizes);
                    }
                    throw throwable;
                }
                Releasables.close(values, sizes);
            }
            this.values = values;
            this.sizes = sizes;
            this.iterator = new LinearCountingIterator();
        }

        @Override
        protected int addEncoded(long bucketOrd, int encoded) {
            assert (encoded != 0);
            return this.set(bucketOrd, encoded);
        }

        protected void ensureCapacity(long bucketOrd, long size) {
            this.values = this.bigArrays.grow(this.values, bucketOrd + 1L);
            this.sizes = this.bigArrays.grow(this.sizes, bucketOrd + 1L);
            IntArray value = this.values.get(bucketOrd);
            value = value == null ? this.bigArrays.newIntArray(size) : this.bigArrays.grow(value, size);
            this.values.set(bucketOrd, value);
        }

        @Override
        protected int size(long bucketOrd) {
            if (bucketOrd >= this.sizes.size()) {
                return 0;
            }
            int size = this.sizes.get(bucketOrd);
            assert (size == this.recomputedSize(bucketOrd));
            return size;
        }

        @Override
        protected AbstractLinearCounting.HashesIterator values(long bucketOrd) {
            this.iterator.reset(this.values.get(bucketOrd), this.size(bucketOrd));
            return this.iterator;
        }

        private int set(long bucketOrd, int value) {
            assert (this.values.get(bucketOrd) != null) : "Added a value without calling ensureCapacity";
            IntArray array = this.values.get(bucketOrd);
            int size = this.sizes.get(bucketOrd);
            array.set(size, value);
            return this.sizes.increment(bucketOrd, 1);
        }

        private int recomputedSize(long bucketOrd) {
            IntArray array = this.values.get(bucketOrd);
            if (array == null) {
                return 0;
            }
            int i = 0;
            while ((long)i < array.size()) {
                int v = array.get(i);
                if (v == 0) {
                    return i;
                }
                ++i;
            }
            return Math.toIntExact(array.size());
        }

        @Override
        public void close() {
            int i = 0;
            while ((long)i < this.values.size()) {
                Releasables.close((Releasable)this.values.get(i));
                ++i;
            }
            Releasables.close(this.values, this.sizes);
        }
    }

    private static class LinearCountingIterator
    implements AbstractLinearCounting.HashesIterator {
        IntArray values;
        int size;
        int value;
        private long pos;

        LinearCountingIterator() {
        }

        void reset(IntArray values, int size) {
            this.values = values;
            this.size = size;
            this.pos = 0L;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean next() {
            if (this.pos < (long)this.size) {
                this.value = this.values.get(this.pos++);
                return true;
            }
            return false;
        }

        @Override
        public int value() {
            return this.value;
        }
    }
}

