/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.mysql;

import java.util.Map;
import org.dbsyncer.connector.mysql.cdc.DqlMySQLListener;
import org.dbsyncer.connector.mysql.validator.DqlMySQLConfigValidator;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDQLConnector;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.PageSql;

public final class DQLMySQLConnector
extends AbstractDQLConnector {
    private final String TYPE = "DqlMySQL";
    private final DqlMySQLConfigValidator configValidator = new DqlMySQLConfigValidator();

    public String getConnectorType() {
        return "DqlMySQL";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public String getPageSql(PageSql config) {
        return config.getQuerySql() + " LIMIT ?,?";
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        int pageIndex = config.getPageIndex();
        return new Object[]{(pageIndex - 1) * pageSize, pageSize};
    }

    public Map<String, String> getSourceCommand(CommandConfig commandConfig) {
        return super.getDqlSourceCommand(commandConfig, true);
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        if (ListenerTypeEnum.isLog((String)listenerType)) {
            return new DqlMySQLListener();
        }
        return null;
    }

    public String generateUniqueCode() {
        return "/*dbs*/";
    }
}

