/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.file.cdc;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.file.FileConnectorInstance;
import org.dbsyncer.connector.file.FileException;
import org.dbsyncer.connector.file.cdc.BufferedRandomAccessFile;
import org.dbsyncer.connector.file.config.FileConfig;
import org.dbsyncer.connector.file.model.FileResolver;
import org.dbsyncer.connector.file.model.FileSchema;
import org.dbsyncer.sdk.listener.AbstractListener;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.model.ChangedOffset;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.dbsyncer.sdk.model.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FileListener
extends AbstractListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String POS_PREFIX = "pos_";
    private static final String CHARSET_NAME = "UTF-8";
    private final Lock connectLock = new ReentrantLock();
    private volatile boolean connected;
    private FileConnectorInstance instance;
    private WatchService watchService;
    private Worker worker;
    private Map<String, PipelineResolver> pipeline = new ConcurrentHashMap<String, PipelineResolver>();
    private final FileResolver fileResolver = new FileResolver();
    private char separator;

    public void start() {
        try {
            this.connectLock.lock();
            if (this.connected) {
                this.logger.error("FileExtractor is already started");
                return;
            }
            this.instance = (FileConnectorInstance)this.connectorInstance;
            FileConfig config = this.instance.getConfig();
            String cacheKey = this.connectorService.getConnectorInstanceCacheKey((ConnectorConfig)config);
            this.connected = true;
            this.separator = config.getSeparator();
            this.initPipeline(config.getFileDir());
            this.watchService = FileSystems.getDefault().newWatchService();
            Path p = Paths.get(config.getFileDir(), new String[0]);
            p.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            for (String fileName : this.pipeline.keySet()) {
                this.parseEvent(fileName);
            }
            this.worker = new Worker();
            this.worker.setName("file-parser-" + cacheKey + "_" + this.worker.hashCode());
            this.worker.setDaemon(false);
            this.worker.start();
        }
        catch (Exception e) {
            this.logger.error("\u542f\u52a8\u5931\u8d25:{}", (Object)e.getMessage());
            this.closePipelineAndWatch();
            throw new FileException(e);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    private void initPipeline(String fileDir) throws IOException {
        for (FileSchema fileSchema : this.instance.getFileSchemaList()) {
            String fileName = fileSchema.getFileName();
            String file = fileDir.concat(fileName);
            Assert.isTrue((boolean)new File(file).exists(), (String)String.format("found not file '%s'", file));
            BufferedRandomAccessFile raf = new BufferedRandomAccessFile(file, "r");
            String filePosKey = this.getFilePosKey(fileName);
            if (this.snapshot.containsKey(filePosKey)) {
                ((RandomAccessFile)raf).seek(NumberUtil.toLong((String)((String)this.snapshot.get(filePosKey)), (long)0L));
            } else {
                ((RandomAccessFile)raf).seek(((RandomAccessFile)raf).length());
                this.snapshot.put(filePosKey, String.valueOf(((RandomAccessFile)raf).getFilePointer()));
                super.forceFlushEvent();
            }
            this.pipeline.put(fileName, new PipelineResolver(fileSchema.getFields(), raf));
        }
    }

    public void close() {
        try {
            this.closePipelineAndWatch();
            this.connected = false;
            if (null != this.worker && !this.worker.isInterrupted()) {
                this.worker.interrupt();
                this.worker = null;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5173\u95ed\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    public void refreshEvent(ChangedOffset offset) {
        if (offset.getNextFileName() != null && offset.getPosition() != null) {
            this.snapshot.put(offset.getNextFileName(), String.valueOf(offset.getPosition()));
        }
    }

    private void closePipelineAndWatch() {
        try {
            this.pipeline.values().forEach(pipelineResolver -> IOUtils.closeQuietly((Closeable)pipelineResolver.raf));
            this.pipeline.clear();
            if (null != this.watchService) {
                this.watchService.close();
            }
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage());
        }
    }

    private String getFilePosKey(String fileName) {
        return POS_PREFIX.concat(fileName);
    }

    private void parseEvent(String fileName) throws IOException {
        if (this.pipeline.containsKey(fileName)) {
            String line;
            PipelineResolver pipelineResolver = this.pipeline.get(fileName);
            RandomAccessFile raf = pipelineResolver.raf;
            String filePosKey = this.getFilePosKey(fileName);
            ArrayList<List<Object>> list = new ArrayList<List<Object>>();
            while (null != (line = pipelineResolver.readLine())) {
                if (!StringUtil.isNotBlank((CharSequence)line)) continue;
                list.add(this.fileResolver.parseList(pipelineResolver.fields, this.separator, line));
            }
            if (!CollectionUtils.isEmpty(list)) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    RowChangedEvent event = new RowChangedEvent(fileName, "UPDATE", (List)list.get(i));
                    if (i == size - 1) {
                        event.setNextFileName(filePosKey);
                        event.setPosition((Object)raf.getFilePointer());
                    }
                    this.changeEvent((ChangedEvent)event);
                }
            }
        }
    }

    final class Worker
    extends Thread {
        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted() && FileListener.this.connected) {
                WatchKey watchKey = null;
                try {
                    watchKey = FileListener.this.watchService.take();
                    List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
                    for (WatchEvent<?> event : watchEvents) {
                        FileListener.this.parseEvent(event.context().toString());
                    }
                }
                catch (ClosedWatchServiceException e) {
                    break;
                }
                catch (Exception e) {
                    FileListener.this.logger.error(e.getMessage());
                }
                finally {
                    if (null == watchKey) continue;
                    watchKey.reset();
                }
            }
        }
    }

    final class PipelineResolver {
        List<Field> fields;
        RandomAccessFile raf;
        byte[] b;
        long filePointer;

        public PipelineResolver(List<Field> fields, RandomAccessFile raf) {
            this.fields = fields;
            this.raf = raf;
        }

        public String readLine() throws IOException {
            this.filePointer = this.raf.getFilePointer();
            if (this.filePointer >= this.raf.length()) {
                this.b = new byte[0];
                return null;
            }
            if (this.b == null || this.b.length == 0) {
                this.b = new byte[(int)(this.raf.length() - this.filePointer)];
            }
            this.raf.read(this.b);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int read = 0;
            for (int i = 0; i < this.b.length; ++i) {
                ++read;
                if (this.b[i] == 10 || this.b[i] == 13) break;
                stream.write(this.b[i]);
            }
            this.b = Arrays.copyOfRange(this.b, read, this.b.length);
            this.raf.seek(this.filePointer + (long)read);
            byte[] _b = stream.toByteArray();
            stream.close();
            stream = null;
            return new String(_b, FileListener.CHARSET_NAME);
        }
    }
}

