/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.file.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbsyncer.common.column.Lexer;
import org.dbsyncer.connector.file.column.ColumnValue;
import org.dbsyncer.connector.file.column.impl.FileColumnValue;
import org.dbsyncer.sdk.model.Field;

public class FileResolver {
    private ColumnValue value = new FileColumnValue();

    public Map<String, Object> parseMap(List<Field> fields, char separator, String line) {
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        this.parse(fields, separator, line, (key, value) -> row.put(key, value));
        return row;
    }

    public List<Object> parseList(List<Field> fields, char separator, String line) {
        ArrayList<Object> data = new ArrayList<Object>();
        this.parse(fields, separator, line, (key, value) -> data.add(value));
        return data;
    }

    private Object resolveValue(String typeName, String columnValue) {
        this.value.setValue(columnValue);
        if (this.value.isNull()) {
            return null;
        }
        switch (typeName) {
            case "string": {
                return this.value.asString();
            }
            case "integer": {
                return this.value.asInteger();
            }
            case "date": {
                return this.value.asDate();
            }
            case "timestamp": {
                return this.value.asTimestamp();
            }
            case "boolean": {
                return this.value.asBoolean();
            }
            case "long": {
                return this.value.asLong();
            }
            case "float": {
                return this.value.asFloat();
            }
            case "double": {
                return this.value.asDouble();
            }
            case "time": {
                return this.value.asTime();
            }
            case "bytea": {
                return this.value.asByteArray();
            }
        }
        return null;
    }

    private void parse(List<Field> fields, char separator, String line, ResultSetMapper mapper) {
        int fieldSize = fields.size();
        Lexer lexer = new Lexer(line);
        for (int i = 0; i < fieldSize; ++i) {
            if (lexer.hasNext()) {
                mapper.apply(fields.get(i).getName(), this.resolveValue(fields.get(i).getTypeName(), lexer.nextToken(separator)));
                continue;
            }
            mapper.apply(fields.get(i).getName(), null);
        }
    }

    private static interface ResultSetMapper {
        public void apply(String var1, Object var2);
    }
}

