/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.file.validator;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.file.config.FileConfig;
import org.dbsyncer.connector.file.model.FileSchema;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.springframework.util.Assert;

public class FileConfigValidator
implements ConfigValidator<FileConfig> {
    public void modify(FileConfig fileConfig, Map<String, String> params) {
        String fileDir = params.get("fileDir");
        String schema = params.get("schema");
        String separator = StringUtil.trim((String)params.get("separator"));
        Assert.hasText((String)fileDir, (String)"fileDir is empty.");
        Assert.hasText((String)schema, (String)"schema is empty.");
        Assert.hasText((String)separator, (String)"separator is empty.");
        List fileSchemas = JsonUtil.jsonToArray((String)schema, FileSchema.class);
        Assert.notEmpty((Collection)fileSchemas, (String)"found not file schema.");
        fileDir = fileDir + (!StringUtil.endsWith((CharSequence)fileDir, (CharSequence)File.separator) ? File.separator : "");
        for (FileSchema fileSchema : fileSchemas) {
            String file = fileDir.concat(fileSchema.getFileName());
            Assert.isTrue((boolean)new File(file).exists(), (String)String.format("found not file '%s'", file));
        }
        fileConfig.setFileDir(fileDir);
        fileConfig.setSeparator(separator.charAt(0));
        fileConfig.setSchema(schema);
    }
}

