/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.ddl.alter;

import java.util.LinkedList;
import java.util.List;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.create.table.Index;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.ddl.AlterStrategy;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.sdk.config.DDLConfig;
import org.dbsyncer.sdk.enums.DDLOperationEnum;
import org.dbsyncer.sdk.model.Field;

public class AddStrategy
implements AlterStrategy {
    @Override
    public void parse(AlterExpression expression, DDLConfig ddlConfig, List<FieldMapping> originFiledMapping) {
        if (expression.getColDataTypeList() != null) {
            this.parseAddColumn(expression, ddlConfig, originFiledMapping);
        }
        if (expression.getIndex() != null) {
            this.parseAddIndex(expression, originFiledMapping);
        }
        ddlConfig.setDdlOperationEnum(DDLOperationEnum.ALTER_ADD);
    }

    private void parseAddColumn(AlterExpression expression, DDLConfig ddlConfig, List<FieldMapping> originFiledMapping) {
        for (AlterExpression.ColumnDataType columnDataType : expression.getColDataTypeList()) {
            boolean findColumn = false;
            LinkedList<String> columnSpecs = new LinkedList<String>();
            for (String spe : columnDataType.getColumnSpecs()) {
                spe = StringUtil.replace((String)spe, (String)"`", (String)"");
                spe = StringUtil.replace((String)spe, (String)"\"", (String)"");
                if (findColumn) {
                    String finalSpe = spe;
                    FieldMapping fieldMapping = originFiledMapping.stream().filter(x -> StringUtil.equals((CharSequence)x.getSource().getName(), (CharSequence)finalSpe)).findFirst().get();
                    columnSpecs.add(fieldMapping.getTarget().getName());
                    findColumn = false;
                    continue;
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)spe, (CharSequence)"before") || StringUtil.equalsIgnoreCase((CharSequence)spe, (CharSequence)"after")) {
                    findColumn = true;
                }
                columnSpecs.add(spe);
            }
            columnDataType.setColumnSpecs(columnSpecs);
            String columName = columnDataType.getColumnName();
            columName = StringUtil.replace((String)columName, (String)"`", (String)"");
            columName = StringUtil.replace((String)columName, (String)"\"", (String)"");
            Field field = new Field(columName, columnDataType.getColDataType().getDataType(), 0);
            ddlConfig.getAddFields().add(field);
        }
    }

    private void parseAddIndex(AlterExpression expression, List<FieldMapping> originFiledMapping) {
        Index index = expression.getIndex();
        List columnNames = index.getColumns();
        LinkedList<Index.ColumnParams> targetNames = new LinkedList<Index.ColumnParams>();
        for (Index.ColumnParams columnParams : columnNames) {
            FieldMapping fieldMapping = originFiledMapping.stream().filter(x -> StringUtil.equals((CharSequence)x.getSource().getName(), (CharSequence)columnParams.getColumnName())).findFirst().get();
            Index.ColumnParams target = new Index.ColumnParams(fieldMapping.getTarget().getName(), columnParams.getParams());
            targetNames.add(target);
        }
        index.setColumns(targetNames);
    }
}

