/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.ddl.alter;

import java.util.List;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.ddl.AlterStrategy;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.sdk.config.DDLConfig;
import org.dbsyncer.sdk.enums.DDLOperationEnum;
import org.dbsyncer.sdk.model.Field;

public class DropStrategy
implements AlterStrategy {
    @Override
    public void parse(AlterExpression expression, DDLConfig ddlConfig, List<FieldMapping> originalFieldMappings) {
        if (expression.getColumnName() != null) {
            this.dropColumn(expression, ddlConfig, originalFieldMappings);
        }
        if (expression.getIndex() != null) {
            this.dropIndex(expression, originalFieldMappings);
        }
        ddlConfig.setDdlOperationEnum(DDLOperationEnum.ALTER_DROP);
    }

    private void dropColumn(AlterExpression expression, DDLConfig ddlConfig, List<FieldMapping> originalFieldMappings) {
        String columnName = StringUtil.replace((String)expression.getColumnName(), (String)"`", (String)"");
        columnName = StringUtil.replace((String)columnName, (String)"\"", (String)"");
        Field field = new Field(columnName, null, 0);
        String finalColumnName = columnName;
        originalFieldMappings.stream().filter(x -> StringUtil.equals((CharSequence)x.getSource().getName(), (CharSequence)finalColumnName)).findFirst().ifPresent(fieldMapping -> expression.setColumnName(fieldMapping.getTarget().getName()));
        ddlConfig.getRemoveFields().add(field);
    }

    private void dropIndex(AlterExpression expression, List<FieldMapping> originalFieldMappings) {
    }
}

