/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.flush.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.dbsyncer.common.QueueOverflowException;
import org.dbsyncer.common.config.BufferActuatorConfig;
import org.dbsyncer.common.config.GeneralBufferConfig;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.parser.ParserComponent;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.ddl.DDLParser;
import org.dbsyncer.parser.event.RefreshOffsetEvent;
import org.dbsyncer.parser.flush.AbstractBufferActuator;
import org.dbsyncer.parser.model.BatchWriter;
import org.dbsyncer.parser.model.Connector;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Picker;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.parser.model.WriterRequest;
import org.dbsyncer.parser.model.WriterResponse;
import org.dbsyncer.parser.sql.impl.DeleteSql;
import org.dbsyncer.parser.sql.impl.InsertSql;
import org.dbsyncer.parser.sql.impl.UpdateSql;
import org.dbsyncer.parser.strategy.FlushStrategy;
import org.dbsyncer.parser.util.ConvertUtil;
import org.dbsyncer.parser.util.PickerUtil;
import org.dbsyncer.plugin.PluginFactory;
import org.dbsyncer.plugin.impl.IncrementPluginContext;
import org.dbsyncer.sdk.config.DDLConfig;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.enums.ChangedEventTypeEnum;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.plugin.PluginContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class GeneralBufferActuator
extends AbstractBufferActuator<WriterRequest, WriterResponse> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private GeneralBufferConfig generalBufferConfig;
    @Resource
    private Executor generalExecutor;
    @Resource
    private ConnectorFactory connectorFactory;
    @Resource
    private ParserComponent parserComponent;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private PluginFactory pluginFactory;
    @Resource
    private FlushStrategy flushStrategy;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private DDLParser ddlParser;

    @PostConstruct
    public void init() {
        this.setConfig((BufferActuatorConfig)this.generalBufferConfig);
        this.buildConfig();
    }

    @Override
    protected String getPartitionKey(WriterRequest request) {
        return request.getTableGroupId();
    }

    @Override
    protected void partition(WriterRequest request, WriterResponse response) {
        if (!CollectionUtils.isEmpty((Map)request.getRow())) {
            response.getDataList().add(request.getRow());
        }
        if (request.getChangedOffset() != null) {
            response.getOffsetList().add(request.getChangedOffset());
        }
        if (!response.isMerged()) {
            response.setTableGroupId(request.getTableGroupId());
            response.setEvent(request.getEvent());
            response.setTypeEnum(request.getTypeEnum());
            response.setSql(request.getSql());
            response.setMerged(true);
        }
    }

    @Override
    protected boolean skipPartition(WriterRequest nextRequest, WriterResponse response) {
        return !StringUtil.equals((CharSequence)nextRequest.getEvent(), (CharSequence)response.getEvent()) || ChangedEventTypeEnum.isDDL((ChangedEventTypeEnum)response.getTypeEnum());
    }

    @Override
    protected void pull(WriterResponse response) {
        TableGroup tableGroup = this.profileComponent.getTableGroup(response.getTableGroupId());
        Mapping mapping = this.profileComponent.getMapping(tableGroup.getMappingId());
        TableGroup group = PickerUtil.mergeTableGroupConfig(mapping, tableGroup);
        if (ChangedEventTypeEnum.isDDL((ChangedEventTypeEnum)response.getTypeEnum())) {
            this.parseDDl(response, mapping, group);
            return;
        }
        if (ChangedEventTypeEnum.isSQL((ChangedEventTypeEnum)response.getTypeEnum())) {
            this.parseSql(response, mapping, group);
            return;
        }
        String sourceTableName = group.getSourceTable().getName();
        String targetTableName = group.getTargetTable().getName();
        String event = response.getEvent();
        Picker picker = new Picker(group.getFieldMapping());
        List<Map> sourceDataList = response.getDataList();
        List<Map> targetDataList = picker.pickTargetData(sourceDataList);
        ConvertUtil.convert(group.getConvert(), targetDataList);
        ConnectorInstance sConnectorInstance = this.connectorFactory.connect(this.getConnectorConfig(mapping.getSourceConnectorId()));
        ConnectorInstance tConnectorInstance = this.connectorFactory.connect(this.getConnectorConfig(mapping.getTargetConnectorId()));
        IncrementPluginContext context = new IncrementPluginContext(sConnectorInstance, tConnectorInstance, sourceTableName, targetTableName, event, sourceDataList, targetDataList);
        this.pluginFactory.convert(group.getPlugin(), (PluginContext)context);
        BatchWriter batchWriter = new BatchWriter(tConnectorInstance, group.getCommand(), targetTableName, event, picker.getTargetFields(), targetDataList, this.generalBufferConfig.getBufferWriterCount());
        Result result = this.parserComponent.writeBatch((PluginContext)context, batchWriter, this.getExecutor());
        this.applicationContext.publishEvent((ApplicationEvent)new RefreshOffsetEvent(this.applicationContext, response.getOffsetList()));
        result.setTableGroupId(tableGroup.getId());
        result.setTargetTableGroupName(targetTableName);
        this.flushStrategy.flushIncrementData(mapping.getMetaId(), result, event);
        this.pluginFactory.postProcessAfter(group.getPlugin(), (PluginContext)context);
    }

    @Override
    protected void offerFailed(BlockingQueue<WriterRequest> queue, WriterRequest request) {
        throw new QueueOverflowException("\u7f13\u5b58\u961f\u5217\u5df2\u6ee1");
    }

    @Override
    public Executor getExecutor() {
        return this.generalExecutor;
    }

    private void parseDDl(WriterResponse response, Mapping mapping, TableGroup tableGroup) {
        try {
            ConnectorConfig sConnConfig = this.getConnectorConfig(mapping.getSourceConnectorId());
            ConnectorConfig tConnConfig = this.getConnectorConfig(mapping.getTargetConnectorId());
            String sConnType = sConnConfig.getConnectorType();
            String tConnType = tConnConfig.getConnectorType();
            if (StringUtil.equals((CharSequence)sConnType, (CharSequence)tConnType)) {
                String targetTableName = tableGroup.getTargetTable().getName();
                List<FieldMapping> originalFieldMappings = tableGroup.getFieldMapping();
                DDLConfig targetDDLConfig = this.ddlParser.parseDDlConfig(response.getSql(), tConnType, targetTableName, originalFieldMappings);
                ConnectorInstance tConnectorInstance = this.connectorFactory.connect(tConnConfig);
                Result result = this.connectorFactory.writerDDL(tConnectorInstance, targetDDLConfig);
                result.setTableGroupId(tableGroup.getId());
                result.setTargetTableGroupName(targetTableName);
                MetaInfo targetMetaInfo = this.parserComponent.getMetaInfo(mapping.getTargetConnectorId(), targetTableName);
                MetaInfo originMetaInfo = this.parserComponent.getMetaInfo(mapping.getSourceConnectorId(), tableGroup.getSourceTable().getName());
                tableGroup.getSourceTable().setColumn(originMetaInfo.getColumn());
                tableGroup.getTargetTable().setColumn(targetMetaInfo.getColumn());
                tableGroup.setFieldMapping(this.ddlParser.refreshFiledMappings(originalFieldMappings, originMetaInfo, targetMetaInfo, targetDDLConfig));
                Map<String, String> commands = this.parserComponent.getCommand(mapping, tableGroup);
                tableGroup.setCommand(commands);
                this.profileComponent.editTableGroup(tableGroup);
                this.applicationContext.publishEvent((ApplicationEvent)new RefreshOffsetEvent(this.applicationContext, response.getOffsetList()));
                this.flushStrategy.flushIncrementData(mapping.getMetaId(), result, response.getEvent());
                return;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        this.logger.warn("\u6682\u53ea\u652f\u6301\u6570\u636e\u5e93\u540c\u6e90\u5e76\u4e14\u662f\u5173\u7cfb\u6027\u89e3\u6790DDL");
    }

    private void parseSql(WriterResponse response, Mapping mapping, TableGroup group) {
        String event;
        String sql = response.getSql();
        String sourceTableName = group.getSourceTable().getName();
        String targetTableName = group.getTargetTable().getName();
        switch (event = response.getEvent()) {
            case "INSERT": {
                InsertSql insertSql = new InsertSql(sql, sourceTableName, targetTableName, group.getFieldMapping());
                sql = insertSql.parse();
                break;
            }
            case "UPDATE": {
                UpdateSql updateSql = new UpdateSql(sql, sourceTableName, targetTableName, group.getFieldMapping());
                sql = updateSql.parse();
                break;
            }
            case "DELETE": {
                DeleteSql deleteSql = new DeleteSql(sql, sourceTableName, targetTableName, group.getFieldMapping());
                sql = deleteSql.parse();
                break;
            }
        }
        this.logger.info("execute sql:{}", (Object)sql);
        ConnectorConfig tConnConfig = this.getConnectorConfig(mapping.getTargetConnectorId());
        ConnectorInstance tConnectorInstance = this.connectorFactory.connect(tConnConfig);
        DDLConfig ddlConfig = new DDLConfig();
        ddlConfig.setSql(sql);
        Result result = this.connectorFactory.writerDDL(tConnectorInstance, ddlConfig);
        this.applicationContext.publishEvent((ApplicationEvent)new RefreshOffsetEvent(this.applicationContext, response.getOffsetList()));
        result.setTableGroupId(group.getId());
        result.setTargetTableGroupName(targetTableName);
        this.flushStrategy.flushIncrementData(mapping.getMetaId(), result, event);
    }

    private ConnectorConfig getConnectorConfig(String connectorId) {
        Assert.hasText((String)connectorId, (String)"Connector id can not be empty.");
        Connector conn = this.profileComponent.getConnector(connectorId);
        Assert.notNull((Object)conn, (String)"Connector can not be null.");
        return conn.getConfig();
    }
}

