/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.model.Convert;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.Filter;
import org.springframework.beans.BeanUtils;

public abstract class PickerUtil {
    public static TableGroup mergeTableGroupConfig(Mapping mapping, TableGroup tableGroup) {
        TableGroup group = new TableGroup();
        BeanUtils.copyProperties((Object)tableGroup, (Object)group);
        group.setParams(CollectionUtils.isEmpty(tableGroup.getParams()) ? mapping.getParams() : tableGroup.getParams());
        group.setFilter(CollectionUtils.isEmpty(tableGroup.getFilter()) ? mapping.getFilter() : tableGroup.getFilter());
        group.setConvert(CollectionUtils.isEmpty(tableGroup.getConvert()) ? mapping.getConvert() : tableGroup.getConvert());
        group.setPlugin(null == tableGroup.getPlugin() ? mapping.getPlugin() : tableGroup.getPlugin());
        PickerUtil.appendFieldMapping(mapping, group);
        return group;
    }

    public static Map<String, Field> convert2Map(List<Field> col) {
        return col.stream().collect(Collectors.toMap(Field::getName, f -> f, (k1, k2) -> k1));
    }

    private static void appendFieldMapping(Mapping mapping, TableGroup group) {
        List<Convert> convert;
        List<Filter> filter;
        List<FieldMapping> fieldMapping = group.getFieldMapping();
        String eventFieldName = mapping.getListener().getEventFieldName();
        if (StringUtil.isNotBlank((CharSequence)eventFieldName)) {
            Map<String, Field> fields = PickerUtil.convert2Map(group.getSourceTable().getColumn());
            PickerUtil.addFieldMapping(fieldMapping, eventFieldName, fields, true);
        }
        if (!CollectionUtils.isEmpty(filter = group.getFilter())) {
            Map<String, Field> fields = PickerUtil.convert2Map(group.getSourceTable().getColumn());
            filter.forEach(f -> PickerUtil.addFieldMapping(fieldMapping, f.getName(), fields, true));
        }
        if (!CollectionUtils.isEmpty(convert = group.getConvert())) {
            Map<String, Field> fields = PickerUtil.convert2Map(group.getTargetTable().getColumn());
            convert.forEach(c -> PickerUtil.addFieldMapping(fieldMapping, c.getName(), fields, false));
        }
    }

    private static void addFieldMapping(List<FieldMapping> fieldMapping, String name, Map<String, Field> fields, boolean checkSource) {
        if (StringUtil.isNotBlank((CharSequence)name)) {
            boolean exist = false;
            for (FieldMapping m : fieldMapping) {
                Field f = checkSource ? m.getSource() : m.getTarget();
                if (null == f || !StringUtil.equals((CharSequence)f.getName(), (CharSequence)name)) continue;
                exist = true;
                break;
            }
            if (!exist && null != fields.get(name)) {
                FieldMapping fm = checkSource ? new FieldMapping(fields.get(name), null) : new FieldMapping(null, fields.get(name));
                fieldMapping.add(fm);
            }
        }
    }
}

