/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.manager.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.dbsyncer.common.scheduled.ScheduledTaskJob;
import org.dbsyncer.common.scheduled.ScheduledTaskService;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.manager.AbstractPuller;
import org.dbsyncer.manager.ManagerException;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.consumer.impl.LogConsumer;
import org.dbsyncer.parser.consumer.impl.QuartzConsumer;
import org.dbsyncer.parser.event.RefreshOffsetEvent;
import org.dbsyncer.parser.flush.impl.BufferActuatorRouter;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Connector;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.config.ListenerConfig;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.listener.AbstractListener;
import org.dbsyncer.sdk.listener.AbstractQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.listener.Watcher;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.model.TableGroupQuartzCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public final class IncrementPuller
extends AbstractPuller
implements ApplicationListener<RefreshOffsetEvent>,
ScheduledTaskJob {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private BufferActuatorRouter bufferActuatorRouter;
    @Resource
    private ScheduledTaskService scheduledTaskService;
    @Resource
    private ConnectorFactory connectorFactory;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private LogService logService;
    private Map<String, Listener> map = new ConcurrentHashMap<String, Listener>();

    @PostConstruct
    private void init() {
        this.scheduledTaskService.start(3000L, (ScheduledTaskJob)this);
    }

    @Override
    public void start(Mapping mapping) {
        String mappingId = mapping.getId();
        String metaId = mapping.getMetaId();
        this.logger.info("\u5f00\u59cb\u589e\u91cf\u540c\u6b65\uff1a{}, {}", (Object)metaId, (Object)mapping.getName());
        Connector connector = this.profileComponent.getConnector(mapping.getSourceConnectorId());
        Assert.notNull((Object)connector, (String)"\u8fde\u63a5\u5668\u4e0d\u80fd\u4e3a\u7a7a.");
        List list = this.profileComponent.getSortedTableGroupAll(mappingId);
        Assert.notEmpty((Collection)list, (String)"\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a.");
        Meta meta = this.profileComponent.getMeta(metaId);
        Assert.notNull((Object)meta, (String)"Meta\u4e0d\u80fd\u4e3a\u7a7a.");
        Thread worker = new Thread(() -> {
            try {
                long now = Instant.now().toEpochMilli();
                meta.setBeginTime(now);
                meta.setEndTime(now);
                this.profileComponent.editConfigModel((ConfigModel)meta);
                this.map.putIfAbsent(metaId, this.getListener(mapping, connector, list, meta));
                this.map.get(metaId).start();
            }
            catch (Exception e) {
                this.close(metaId);
                this.logService.log((LogType)LogType.TableGroupLog.INCREMENT_FAILED, e.getMessage());
                this.logger.error("\u8fd0\u884c\u5f02\u5e38\uff0c\u7ed3\u675f\u589e\u91cf\u540c\u6b65{}:{}", (Object)metaId, (Object)e.getMessage());
            }
        });
        worker.setName("increment-worker-" + mapping.getId());
        worker.setDaemon(false);
        worker.start();
    }

    @Override
    public void close(String metaId) {
        Listener listener = this.map.get(metaId);
        if (null != listener) {
            this.bufferActuatorRouter.unbind(metaId);
            listener.close();
        }
        this.map.remove(metaId);
        this.publishClosedEvent(metaId);
        this.logger.info("\u5173\u95ed\u6210\u529f:{}", (Object)metaId);
    }

    public void onApplicationEvent(RefreshOffsetEvent event) {
        List offsetList = event.getOffsetList();
        if (!CollectionUtils.isEmpty((Collection)offsetList)) {
            offsetList.forEach(offset -> {
                if (offset.isRefreshOffset() && this.map.containsKey(offset.getMetaId())) {
                    this.map.get(offset.getMetaId()).refreshEvent(offset);
                }
            });
        }
    }

    public void run() {
        this.map.values().forEach(listener -> listener.flushEvent());
    }

    private Listener getListener(Mapping mapping, Connector connector, List<TableGroup> list, Meta meta) {
        AbstractListener abstractListener;
        ConnectorConfig connectorConfig = connector.getConfig();
        ListenerConfig listenerConfig = mapping.getListener();
        String listenerType = listenerConfig.getListenerType();
        Listener listener = this.connectorFactory.getListener(connectorConfig.getConnectorType(), listenerType);
        if (null == listener) {
            throw new ManagerException(String.format("Unsupported listener type \"%s\".", connectorConfig.getConnectorType()));
        }
        if (ListenerTypeEnum.isTiming((String)listenerType) && listener instanceof AbstractQuartzListener) {
            AbstractQuartzListener quartzListener = (AbstractQuartzListener)listener;
            quartzListener.setCommands(list.stream().map(t -> new TableGroupQuartzCommand(t.getSourceTable(), t.getCommand())).collect(Collectors.toList()));
            quartzListener.register((Watcher)new QuartzConsumer().init(this.bufferActuatorRouter, this.profileComponent, this.logService, meta.getId(), mapping, list));
        }
        if (ListenerTypeEnum.isLog((String)listenerType) && listener instanceof AbstractListener) {
            abstractListener = (AbstractListener)listener;
            abstractListener.register((Watcher)new LogConsumer().init(this.bufferActuatorRouter, this.profileComponent, this.logService, meta.getId(), mapping, list));
        }
        if (listener instanceof AbstractListener) {
            abstractListener = (AbstractListener)listener;
            HashSet filterTable = new HashSet();
            ArrayList sourceTable = new ArrayList();
            list.forEach(t -> {
                Table table = t.getSourceTable();
                if (!filterTable.contains(t.getName())) {
                    sourceTable.add(table);
                }
                filterTable.add(table.getName());
            });
            abstractListener.setConnectorService(this.connectorFactory.getConnectorService(connectorConfig.getConnectorType()));
            abstractListener.setConnectorInstance(this.connectorFactory.connect(connectorConfig));
            abstractListener.setScheduledTaskService(this.scheduledTaskService);
            abstractListener.setConnectorConfig(connectorConfig);
            abstractListener.setListenerConfig(listenerConfig);
            abstractListener.setFilterTable(filterTable);
            abstractListener.setSourceTable(sourceTable);
            abstractListener.setSnapshot(meta.getSnapshot());
            abstractListener.setMetaId(meta.getId());
        }
        listener.init();
        return listener;
    }
}

