/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.sqlserver;

import java.util.List;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.sqlserver.cdc.DqlSqlServerListener;
import org.dbsyncer.connector.sqlserver.validator.DqlSqlServerConfigValidator;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDQLConnector;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.PageSql;

public final class DQLSqlServerConnector
extends AbstractDQLConnector {
    private final String TYPE = "DqlSqlServer";
    private final DqlSqlServerConfigValidator configValidator = new DqlSqlServerConfigValidator();

    public String getConnectorType() {
        return "DqlSqlServer";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        if (ListenerTypeEnum.isLog((String)listenerType)) {
            return new DqlSqlServerListener();
        }
        return null;
    }

    public String getPageSql(PageSql config) {
        List primaryKeys = config.getPrimaryKeys();
        String orderBy = StringUtil.join((Iterable)primaryKeys, (String)",");
        return String.format("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY %s) AS SQLSERVER_ROW_ID, * FROM (%s) S) A WHERE A.SQLSERVER_ROW_ID BETWEEN ? AND ?", orderBy, config.getQuerySql());
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        int pageIndex = config.getPageIndex();
        return new Object[]{(pageIndex - 1) * pageSize + 1, pageIndex * pageSize};
    }
}

