/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.elasticsearch.ESConnectorInstance;
import org.dbsyncer.connector.elasticsearch.api.EasyRestHighLevelClient;
import org.dbsyncer.connector.elasticsearch.cdc.ESQuartzListener;
import org.dbsyncer.connector.elasticsearch.config.ESConfig;
import org.dbsyncer.connector.elasticsearch.enums.ESFieldTypeEnum;
import org.dbsyncer.connector.elasticsearch.schema.ESDateValueMapper;
import org.dbsyncer.connector.elasticsearch.schema.ESOtherValueMapper;
import org.dbsyncer.connector.elasticsearch.validator.ESConfigValidator;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.connector.AbstractConnector;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.enums.FilterEnum;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.enums.OperationEnum;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.Filter;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticsearchConnector
extends AbstractConnector
implements ConnectorService<ESConnectorInstance, ESConfig> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String TYPE = "Elasticsearch";
    private final Map<String, FilterMapper> filters = new LinkedHashMap<String, FilterMapper>();
    private final ESConfigValidator configValidator = new ESConfigValidator();

    public ElasticsearchConnector() {
        this.VALUE_MAPPERS.put(91, new ESDateValueMapper());
        this.VALUE_MAPPERS.put(1111, new ESOtherValueMapper());
        this.filters.putIfAbsent(FilterEnum.EQUAL.getName(), (builder, k, v) -> builder.must((QueryBuilder)QueryBuilders.matchQuery((String)k, (Object)v)));
        this.filters.putIfAbsent(FilterEnum.NOT_EQUAL.getName(), (builder, k, v) -> builder.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)k, (Object)v)));
        this.filters.putIfAbsent(FilterEnum.GT.getName(), (builder, k, v) -> builder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)k).gt((Object)v)));
        this.filters.putIfAbsent(FilterEnum.LT.getName(), (builder, k, v) -> builder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)k).lt((Object)v)));
        this.filters.putIfAbsent(FilterEnum.GT_AND_EQUAL.getName(), (builder, k, v) -> builder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)k).gte((Object)v)));
        this.filters.putIfAbsent(FilterEnum.LT_AND_EQUAL.getName(), (builder, k, v) -> builder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)k).lte((Object)v)));
        this.filters.putIfAbsent(FilterEnum.LIKE.getName(), (builder, k, v) -> builder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)k, (String)v)));
    }

    public String getConnectorType() {
        return "Elasticsearch";
    }

    public boolean isSupportedTiming() {
        return true;
    }

    public boolean isSupportedLog() {
        return false;
    }

    public Class<ESConfig> getConfigClass() {
        return ESConfig.class;
    }

    public ConnectorInstance connect(ESConfig config) {
        return new ESConnectorInstance(config);
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public void disconnect(ESConnectorInstance connectorInstance) {
        connectorInstance.close();
    }

    public boolean isAlive(ESConnectorInstance connectorInstance) {
        try {
            EasyRestHighLevelClient client = connectorInstance.getConnection();
            return client.ping(RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new ElasticsearchException(e.getMessage(), new Object[0]);
        }
    }

    public String getConnectorInstanceCacheKey(ESConfig config) {
        return String.format("%s-%s-%s-%s", config.getConnectorType(), config.getUrl(), config.getIndex(), config.getUsername());
    }

    public List<Table> getTable(ESConnectorInstance connectorInstance) {
        try {
            ESConfig config = connectorInstance.getConfig();
            GetIndexRequest request = new GetIndexRequest(new String[]{config.getIndex()});
            GetIndexResponse indexResponse = connectorInstance.getConnection().indices().get(request, RequestOptions.DEFAULT);
            MappingMetadata mappingMetaData = (MappingMetadata)indexResponse.getMappings().get(config.getIndex());
            ArrayList<Table> tables = new ArrayList<Table>();
            if (Version.V_7_0_0.after(connectorInstance.getVersion())) {
                Map sourceMap = (Map)XContentHelper.convertToMap((BytesReference)mappingMetaData.source().compressedReference(), (boolean)true, null).v2();
                sourceMap.keySet().forEach(tableName -> tables.add(new Table(tableName)));
                return tables;
            }
            tables.add(new Table(mappingMetaData.type()));
            return tables;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new ElasticsearchException((Throwable)e);
        }
    }

    public MetaInfo getMetaInfo(ESConnectorInstance connectorInstance, String tableName) {
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            ESConfig config = connectorInstance.getConfig();
            GetIndexRequest request = new GetIndexRequest(new String[]{config.getIndex()});
            GetIndexResponse indexResponse = connectorInstance.getConnection().indices().get(request, RequestOptions.DEFAULT);
            MappingMetadata mappingMetaData = (MappingMetadata)indexResponse.getMappings().get(config.getIndex());
            if (Version.V_7_0_0.after(connectorInstance.getVersion())) {
                Map sourceMap = (Map)XContentHelper.convertToMap((BytesReference)mappingMetaData.source().compressedReference(), (boolean)true, null).v2();
                this.parseProperties(fields, (Map)sourceMap.get(tableName));
                return new MetaInfo().setColumn(fields);
            }
            this.parseProperties(fields, mappingMetaData.sourceAsMap());
            return new MetaInfo().setColumn(fields);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new ElasticsearchException((Throwable)e);
        }
    }

    public long getCount(ESConnectorInstance connectorInstance, Map<String, String> command) {
        try {
            ESConfig config = connectorInstance.getConfig();
            SearchSourceBuilder builder = new SearchSourceBuilder();
            this.genSearchSourceBuilder(builder, command);
            if (Version.V_7_0_0.onOrBefore(connectorInstance.getVersion())) {
                builder.trackTotalHits(true);
            }
            builder.from(0);
            builder.size(0);
            SearchRequest request = new SearchRequest(new String[]{config.getIndex()}, builder);
            SearchResponse response = connectorInstance.getConnection().searchWithVersion(request, RequestOptions.DEFAULT);
            return response.getHits().getTotalHits().value;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new ElasticsearchException((Throwable)e);
        }
    }

    public Result reader(ESConnectorInstance connectorInstance, ReaderConfig config) {
        ESConfig cfg = connectorInstance.getConfig();
        SearchSourceBuilder builder = new SearchSourceBuilder();
        this.genSearchSourceBuilder(builder, config.getCommand());
        builder.from((config.getPageIndex() - 1) * config.getPageSize());
        builder.size(config.getPageSize());
        builder.timeout(TimeValue.timeValueMillis((long)10L));
        List primaryKeys = PrimaryKeyUtil.findTablePrimaryKeys((Table)config.getTable());
        if (!CollectionUtils.isEmpty((Collection)primaryKeys)) {
            primaryKeys.forEach(pk -> builder.sort(pk, SortOrder.ASC));
            if (!CollectionUtils.isEmpty((Object[])config.getCursors())) {
                builder.from(0);
                builder.searchAfter(config.getCursors());
            }
        }
        try {
            SearchRequest rq = new SearchRequest(new String[]{cfg.getIndex()}, builder);
            SearchResponse searchResponse = connectorInstance.getConnection().searchWithVersion(rq, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            SearchHit[] searchHits = hits.getHits();
            ArrayList<Map> list = new ArrayList<Map>();
            for (SearchHit hit : searchHits) {
                list.add(hit.getSourceAsMap());
            }
            return new Result(list);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new ElasticsearchException(e.getMessage(), new Object[0]);
        }
    }

    public Result writer(ESConnectorInstance connectorInstance, WriterBatchConfig config) {
        List data = config.getData();
        if (CollectionUtils.isEmpty((Collection)data) || CollectionUtils.isEmpty((Collection)config.getFields())) {
            this.logger.error("writer data can not be empty.");
            throw new ElasticsearchException("writer data can not be empty.", new Object[0]);
        }
        Result result = new Result();
        ESConfig cfg = connectorInstance.getConfig();
        List pkFields = PrimaryKeyUtil.findConfigPrimaryKeyFields((WriterBatchConfig)config);
        try {
            BulkRequest request = new BulkRequest();
            String pk = ((Field)pkFields.get(0)).getName();
            data.forEach(row -> this.addRequest(request, cfg.getIndex(), config.getTableName(), config.getEvent(), String.valueOf(row.get(pk)), (Map)row));
            BulkResponse response = connectorInstance.getConnection().bulkWithVersion(request, RequestOptions.DEFAULT);
            RestStatus restStatus = response.status();
            if (restStatus.getStatus() != RestStatus.OK.getStatus()) {
                throw new ElasticsearchException(String.format("error code:%s", restStatus.getStatus()), new Object[0]);
            }
            result.addSuccessData(data);
        }
        catch (Exception e) {
            result.addFailData(data);
            result.getError().append(e.getMessage()).append(System.lineSeparator());
            this.logger.error(e.getMessage());
        }
        return result;
    }

    public Map<String, String> getSourceCommand(CommandConfig commandConfig) {
        List filter;
        HashMap<String, String> command = new HashMap<String, String>();
        Table table = commandConfig.getTable();
        List column = table.getColumn();
        if (!CollectionUtils.isEmpty((Collection)column)) {
            List fieldNames = column.stream().map(c -> c.getName()).collect(Collectors.toList());
            command.put("QUERY", StringUtil.join(fieldNames, (String)","));
        }
        if (!CollectionUtils.isEmpty((Collection)(filter = commandConfig.getFilter()))) {
            command.put("QUERY_FILTER", JsonUtil.objToJson((Object)filter));
        }
        return command;
    }

    public Map<String, String> getTargetCommand(CommandConfig commandConfig) {
        PrimaryKeyUtil.findTablePrimaryKeys((Table)commandConfig.getTable());
        return Collections.EMPTY_MAP;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new ESQuartzListener();
        }
        return null;
    }

    private void parseProperties(List<Field> fields, Map<String, Object> sourceMap) {
        Map properties = (Map)sourceMap.get("properties");
        if (CollectionUtils.isEmpty((Map)properties)) {
            throw new ElasticsearchException("\u67e5\u8be2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a.", new Object[0]);
        }
        properties.forEach((fieldName, c) -> {
            Map fieldDesc = (Map)c;
            String columnType = (String)fieldDesc.get("type");
            if (StringUtil.equals((CharSequence)ESFieldTypeEnum.DATE.getCode(), (CharSequence)columnType) && fieldDesc.containsKey("format")) {
                fields.add(new Field(fieldName, columnType, ESFieldTypeEnum.KEYWORD.getType()));
                return;
            }
            fields.add(new Field(fieldName, columnType, ESFieldTypeEnum.getType(columnType)));
        });
    }

    private void genSearchSourceBuilder(SearchSourceBuilder builder, Map<String, String> command) {
        String fieldNamesJson = command.get("QUERY");
        if (!StringUtil.isBlank((CharSequence)fieldNamesJson)) {
            builder.fetchSource(StringUtil.split((String)fieldNamesJson, (String)","), null);
        }
        String filterJson = command.get("QUERY_FILTER");
        List filters = null;
        if (!StringUtil.isBlank((CharSequence)filterJson)) {
            filters = JsonUtil.jsonToArray((String)filterJson, Filter.class);
        }
        if (CollectionUtils.isEmpty(filters)) {
            builder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            return;
        }
        List<Filter> and = filters.stream().filter(f -> OperationEnum.isAnd((String)f.getOperation())).collect(Collectors.toList());
        List<Filter> or = filters.stream().filter(f -> OperationEnum.isOr((String)f.getOperation())).collect(Collectors.toList());
        BoolQueryBuilder q = QueryBuilders.boolQuery();
        if (!CollectionUtils.isEmpty(and) && !CollectionUtils.isEmpty(or)) {
            BoolQueryBuilder andQuery = QueryBuilders.boolQuery();
            and.forEach(f -> this.addFilter(andQuery, (Filter)f));
            q.should((QueryBuilder)andQuery);
            this.genShouldQuery(q, or);
            builder.query((QueryBuilder)q);
            return;
        }
        if (!CollectionUtils.isEmpty(or)) {
            this.genShouldQuery(q, or);
            builder.query((QueryBuilder)q);
            return;
        }
        and.forEach(f -> this.addFilter(q, (Filter)f));
        builder.query((QueryBuilder)q);
    }

    private void genShouldQuery(BoolQueryBuilder q, List<Filter> or) {
        or.forEach(f -> {
            BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
            this.addFilter(orQuery, (Filter)f);
            q.should((QueryBuilder)orQuery);
        });
    }

    private void addFilter(BoolQueryBuilder builder, Filter f) {
        if (this.filters.containsKey(f.getFilter())) {
            this.filters.get(f.getFilter()).apply(builder, f.getName(), f.getValue());
        }
    }

    private void addRequest(BulkRequest request, String index, String type, String event, String id, Map data) {
        if (this.isUpdate(event)) {
            UpdateRequest req = new UpdateRequest(index, type, id);
            req.doc(data, XContentType.JSON);
            request.add(req);
            return;
        }
        if (this.isInsert(event)) {
            IndexRequest req = new IndexRequest(index, type, id);
            req.source(data, XContentType.JSON);
            request.add(req);
            return;
        }
        if (this.isDelete(event)) {
            request.add(new DeleteRequest(index, type, id));
        }
    }

    private static interface FilterMapper {
        public void apply(BoolQueryBuilder var1, String var2, String var3);
    }
}

