/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.storage;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.sdk.storage.StorageService;
import org.dbsyncer.storage.impl.DiskStorageService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration
public class StorageSupportConfiguration {
    private final String PREFIX_STORAGE = "dbsyncer.storage";
    private final String STORAGE_TYPE = "dbsyncer.storage.type";
    @Resource
    private Environment environment;
    @Resource
    private ConnectorFactory connectorFactory;

    @Bean
    @ConditionalOnMissingBean
    public StorageService storageService() {
        StorageService storageService;
        String connectorType;
        String storageType;
        Properties properties = new Properties();
        if (this.environment instanceof AbstractEnvironment) {
            AbstractEnvironment ae = (AbstractEnvironment)this.environment;
            MutablePropertySources propertySources = ae.getPropertySources();
            for (PropertySource propertySource : propertySources) {
                boolean applicationConfig = propertySource.getName().contains("application");
                if (!applicationConfig) continue;
                Map props = (Map)propertySource.getSource();
                props.forEach((k, v) -> {
                    if (StringUtil.startsWith((CharSequence)k, (CharSequence)"dbsyncer.storage")) {
                        properties.put(k, v.getValue());
                    }
                });
            }
        }
        if (StringUtil.isNotBlank((CharSequence)(storageType = properties.getProperty("dbsyncer.storage.type"))) && StringUtil.isNotBlank((CharSequence)(connectorType = this.getConnectorType(storageType))) && (storageService = this.connectorFactory.getConnectorService(connectorType).getStorageService()) != null) {
            storageService.init(properties);
            return storageService;
        }
        DiskStorageService storageService2 = new DiskStorageService();
        storageService2.init(properties);
        return storageService2;
    }

    private String getConnectorType(String storageType) {
        for (String connectorType : this.connectorFactory.getConnectorTypeAll()) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)storageType, (CharSequence)connectorType)) continue;
            return connectorType;
        }
        return null;
    }
}

