/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.storage.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.dbsyncer.common.model.Paging;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.sdk.enums.FilterEnum;
import org.dbsyncer.sdk.enums.OperationEnum;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.filter.AbstractFilter;
import org.dbsyncer.sdk.filter.BooleanFilter;
import org.dbsyncer.sdk.filter.Query;
import org.dbsyncer.sdk.storage.AbstractStorageService;
import org.dbsyncer.storage.StorageException;
import org.dbsyncer.storage.impl.DiskQueryHelper;
import org.dbsyncer.storage.lucene.Option;
import org.dbsyncer.storage.lucene.Shard;
import org.dbsyncer.storage.util.DocumentUtil;

public class DiskStorageService
extends AbstractStorageService {
    private Map<String, Shard> shards = new ConcurrentHashMap<String, Shard>();
    private static final String PATH = System.getProperty("user.dir") + File.separatorChar + "data" + File.separatorChar;

    public void init(Properties properties) {
        this.getShard(this.getSharding(StorageEnum.CONFIG, null));
        this.getShard(this.getSharding(StorageEnum.LOG, null));
    }

    protected Paging select(String sharding, Query query) {
        try {
            Shard shard = this.getShard(sharding);
            int pageNum = query.getPageNum() <= 0 ? 1 : query.getPageNum();
            int pageSize = query.getPageSize() <= 0 ? 20 : query.getPageSize();
            boolean desc = query.getSort().isDesc();
            Sort sort = new Sort(new SortField[]{new SortField("updateTime", SortField.Type.LONG, desc), new SortField("createTime", SortField.Type.LONG, desc)});
            Option option = new Option();
            option.setQueryTotal(query.isQueryTotal());
            option.setFieldResolverMap(query.getFieldResolverMap());
            BooleanFilter baseQuery = query.getBooleanFilter();
            List filters = baseQuery.getFilters();
            List clauses = baseQuery.getClauses();
            if (CollectionUtils.isEmpty((Collection)clauses) && CollectionUtils.isEmpty((Collection)filters)) {
                option.setQuery((org.apache.lucene.search.Query)new MatchAllDocsQuery());
                return shard.query(option, pageNum, pageSize, sort);
            }
            HashSet<String> highLightKeys = new HashSet<String>();
            BooleanQuery build = this.buildQuery(filters, clauses, highLightKeys);
            option.setQuery((org.apache.lucene.search.Query)build);
            if (!CollectionUtils.isEmpty(highLightKeys)) {
                option.setHighLightKeys(highLightKeys);
                option.setEnableHighLightSearch(true);
                SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<span style='color:red'>", "</span>");
                option.setHighlighter(new Highlighter((Formatter)formatter, (Scorer)new QueryScorer((org.apache.lucene.search.Query)build)));
            }
            return shard.query(option, pageNum, pageSize, sort);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    protected void delete(String sharding, Query query) {
        Shard shard = this.getShard(sharding);
        BooleanFilter q = query.getBooleanFilter();
        shard.delete((org.apache.lucene.search.Query)this.buildQuery(q.getFilters(), q.getClauses(), new HashSet<String>()));
    }

    public void deleteAll(String sharding) {
        this.shards.computeIfPresent(sharding, (k, v) -> {
            v.deleteAll();
            return v;
        });
        this.shards.remove(sharding);
    }

    protected void batchInsert(StorageEnum type, String sharding, List<Map> list) {
        this.batchExecute(type, sharding, list, (shard, docs) -> shard.insertBatch(docs));
    }

    protected void batchUpdate(StorageEnum type, String sharding, List<Map> list) {
        this.batchExecute(type, sharding, list, (shard, docs) -> {
            for (Document doc : docs) {
                shard.update(this.getPrimaryKeyTerm(doc), doc);
            }
        });
    }

    protected void batchDelete(StorageEnum type, String sharding, List<String> ids) {
        Shard shard = this.getShard(sharding);
        int size = ids.size();
        Term[] terms = new Term[size];
        for (int i = 0; i < size; ++i) {
            terms[i] = this.getPrimaryKeyTerm(ids.get(i));
        }
        shard.deleteBatch(terms);
    }

    public void destroy() throws Exception {
        for (Map.Entry<String, Shard> m : this.shards.entrySet()) {
            m.getValue().close();
        }
        this.shards.clear();
    }

    private BooleanQuery buildQuery(List<AbstractFilter> filters, List<BooleanFilter> clauses, Set<String> highLightKeys) {
        if (!CollectionUtils.isEmpty(filters)) {
            return this.buildQueryWithFilters(filters, highLightKeys);
        }
        return this.buildQueryWithBooleanFilters(clauses, highLightKeys);
    }

    private BooleanQuery buildQueryWithFilters(List<AbstractFilter> filters, Set<String> highLightKeys) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        filters.forEach(p -> {
            FilterEnum filterEnum = FilterEnum.getFilterEnum((String)p.getFilter());
            BooleanClause.Occur occur = this.getOccur(p.getOperation());
            switch (filterEnum) {
                case EQUAL: 
                case LIKE: {
                    builder.add(DiskQueryHelper.newEqual(p), occur);
                    break;
                }
                case LT: {
                    builder.add(DiskQueryHelper.newLessThan(p), occur);
                }
            }
            if (p.isEnableHighLightSearch()) {
                highLightKeys.add(p.getName());
            }
        });
        return builder.build();
    }

    private BooleanQuery buildQueryWithBooleanFilters(List<BooleanFilter> clauses, Set<String> highLightKeys) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        clauses.forEach(c -> {
            if (!CollectionUtils.isEmpty((Collection)c.getFilters())) {
                BooleanQuery cBuild = this.buildQueryWithFilters(c.getFilters(), highLightKeys);
                builder.add((org.apache.lucene.search.Query)cBuild, this.getOccur(c.getOperationEnum().getName()));
            }
        });
        return builder.build();
    }

    private BooleanClause.Occur getOccur(String operation) {
        return OperationEnum.isAnd((String)operation) ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
    }

    private Term getPrimaryKeyTerm(Document doc) {
        return new Term("id", doc.getField("id").stringValue());
    }

    private Term getPrimaryKeyTerm(String id) {
        return new Term("id", id);
    }

    private void batchExecute(StorageEnum type, String sharding, List<Map> list, ExecuteMapper mapper) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Shard shard = this.getShard(sharding);
        ArrayList<Document> docs = new ArrayList<Document>();
        list.forEach(r -> {
            switch (type) {
                case DATA: {
                    docs.add(DocumentUtil.convertData2Doc(r));
                    break;
                }
                case LOG: {
                    docs.add(DocumentUtil.convertLog2Doc(r));
                    break;
                }
                case CONFIG: {
                    docs.add(DocumentUtil.convertConfig2Doc(r));
                    break;
                }
            }
        });
        try {
            mapper.apply(shard, docs);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private Shard getShard(String sharding) {
        return this.shards.computeIfAbsent(sharding, k -> new Shard(PATH + k));
    }

    static interface ExecuteMapper {
        public void apply(Shard var1, List<Document> var2) throws IOException;
    }
}

