/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.storage.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.IOUtils;
import org.dbsyncer.common.model.Paging;
import org.dbsyncer.storage.StorageException;
import org.dbsyncer.storage.lucene.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shard {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File indexPath;
    private Directory directory;
    private Analyzer analyzer;
    private IndexWriter indexWriter;
    private IndexReader indexReader;
    private IndexWriterConfig config;
    private final Object LOCK = new Object();
    private static final int MAX_SIZE = 10000;

    public Shard(String path) {
        try {
            Path dir = Paths.get(path, new String[0]);
            this.indexPath = new File(dir.toUri());
            this.directory = FSDirectory.open((Path)dir);
            this.analyzer = new SmartChineseAnalyzer();
            this.reopen();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public void insertBatch(List<Document> docs) {
        this.execute(docs, () -> this.indexWriter.addDocuments((Iterable)docs));
    }

    public void update(Term term, Document doc) {
        if (null != term) {
            this.execute(doc, () -> this.indexWriter.updateDocument(term, (Iterable)doc));
        }
    }

    public void deleteBatch(Term ... terms) {
        if (null != terms) {
            this.execute(terms, () -> this.indexWriter.deleteDocuments(terms));
        }
    }

    public void delete(Query query) {
        try {
            this.indexWriter.deleteDocuments(new Query[]{query});
            this.indexWriter.flush();
            this.indexWriter.commit();
            this.indexWriter.forceMergeDeletes();
            this.indexWriter.deleteUnusedFiles();
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void deleteAll() {
        try {
            this.close();
            this.directory.close();
            FileUtils.deleteDirectory((File)this.indexPath);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public void close() throws IOException {
        this.indexWriter.commit();
        this.indexReader.close();
        this.indexWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexSearcher getSearcher() throws IOException {
        DirectoryReader changeReader = DirectoryReader.openIfChanged((DirectoryReader)((DirectoryReader)this.indexReader), (IndexWriter)this.indexWriter, (boolean)true);
        if (null != changeReader) {
            this.indexReader.close();
            this.indexReader = null;
            Object object = this.LOCK;
            synchronized (object) {
                if (null == this.indexReader) {
                    this.indexReader = changeReader;
                }
            }
        }
        return new IndexSearcher(this.indexReader);
    }

    public Paging query(Option option, int pageNum, int pageSize, Sort sort) throws IOException {
        IndexSearcher searcher = this.getSearcher();
        TopDocs topDocs = this.getTopDocs(searcher, option.getQuery(), 10000, sort);
        Paging paging = new Paging(pageNum, pageSize);
        paging.setTotal(topDocs.totalHits.value);
        if (option.isQueryTotal()) {
            return paging;
        }
        List<Map> data = this.search(searcher, topDocs, option, pageNum, pageSize);
        paging.setData(data);
        return paging;
    }

    private TopDocs getTopDocs(IndexSearcher searcher, Query query, int maxSize, Sort sort) throws IOException {
        if (null != sort) {
            return searcher.search(query, maxSize, sort);
        }
        return searcher.search(query, maxSize);
    }

    private List<Map> search(IndexSearcher searcher, TopDocs topDocs, Option option, int pageNum, int pageSize) throws IOException {
        ScoreDoc[] docs = topDocs.scoreDocs;
        int total = docs.length;
        int begin = (pageNum - 1) * pageSize;
        int end = pageNum * pageSize;
        begin = begin > total ? total : begin;
        end = end > total ? total : end;
        ArrayList<Map> list = new ArrayList<Map>();
        Document doc = null;
        LinkedHashMap<String, Object> r = null;
        IndexableField f = null;
        Iterator iterator = null;
        while (begin < end) {
            doc = searcher.doc(docs[begin++].doc);
            iterator = doc.iterator();
            r = new LinkedHashMap<String, Object>();
            while (iterator.hasNext()) {
                f = (IndexableField)iterator.next();
                if (option.isEnableHighLightSearch()) {
                    try {
                        String key = f.name();
                        if (option.getHighLightKeys().contains(key)) {
                            String content = doc.get(key);
                            TokenStream tokenStream = this.analyzer.tokenStream("", content);
                            content = option.getHighlighter().getBestFragment(tokenStream, content);
                            r.put(key, content);
                            continue;
                        }
                    }
                    catch (InvalidTokenOffsetsException e) {
                        e.printStackTrace();
                    }
                }
                r.put(f.name(), option.getFieldResolver(f.name()).getValue((Object)f));
            }
            list.add(r);
        }
        return list;
    }

    private void execute(Object value, Callback callback) {
        if (value == null) {
            return;
        }
        if (this.indexWriter.isOpen()) {
            try {
                this.doExecute(callback);
            }
            catch (IOException e) {
                this.logger.error(String.format("\u7d22\u5f15\u5f02\u5e38\uff1a%s", this.indexPath.getAbsolutePath()), (Throwable)e);
            }
            return;
        }
        try {
            this.reopen();
            this.doExecute(callback);
        }
        catch (IOException e) {
            this.logger.error(value.toString());
        }
    }

    private void doExecute(Callback callback) throws IOException {
        callback.execute();
        this.indexWriter.flush();
        this.indexWriter.commit();
    }

    private void reopen() throws IOException {
        Lock writeLock = this.directory.obtainLock("write.lock");
        if (writeLock != null) {
            IOUtils.close((Closeable[])new Closeable[]{writeLock});
        }
        this.config = new IndexWriterConfig(this.analyzer);
        this.config.setRAMBufferSizeMB(32.0);
        this.indexWriter = new IndexWriter(this.directory, this.config);
        this.indexReader = DirectoryReader.open((IndexWriter)this.indexWriter);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    static interface Callback {
        public void execute() throws IOException;
    }
}

