/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.storage.util;

import com.google.protobuf.ByteString;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.BitSet;
import java.util.Map;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import org.apache.commons.io.IOUtils;
import org.dbsyncer.storage.StorageException;
import org.dbsyncer.storage.binlog.BinlogColumnValue;
import org.dbsyncer.storage.binlog.proto.BinlogMap;
import org.dbsyncer.storage.enums.BinlogByteEnum;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinlogMessageUtil {
    private static final Logger logger = LoggerFactory.getLogger(BinlogMessageUtil.class);

    public static BinlogMap toBinlogMap(Map<String, Object> data) {
        BinlogMap.Builder dataBuilder = BinlogMap.newBuilder();
        data.forEach((k, v) -> {
            ByteString bytes;
            if (null != v && null != (bytes = BinlogMessageUtil.serializeValue(v))) {
                dataBuilder.putRow((String)k, bytes);
            }
        });
        return dataBuilder.build();
    }

    public static ByteString serializeValue(Object v) {
        String type;
        switch (type = v.getClass().getName()) {
            case "[B": {
                return ByteString.copyFrom((byte[])((byte[])v));
            }
            case "java.lang.String": {
                return ByteString.copyFromUtf8((String)((String)v));
            }
            case "org.postgresql.util.PGobject": {
                PGobject pgObject = (PGobject)v;
                return ByteString.copyFromUtf8((String)pgObject.getValue());
            }
            case "java.sql.Timestamp": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.LONG, buffer -> {
                    Timestamp timestamp = (Timestamp)v;
                    buffer.putLong(timestamp.getTime());
                });
            }
            case "java.sql.Date": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.LONG, buffer -> {
                    Date date = (Date)v;
                    buffer.putLong(date.getTime());
                });
            }
            case "java.util.Date": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.LONG, buffer -> {
                    java.util.Date uDate = (java.util.Date)v;
                    buffer.putLong(uDate.getTime());
                });
            }
            case "java.sql.Time": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.LONG, buffer -> {
                    Time time = (Time)v;
                    buffer.putLong(time.getTime());
                });
            }
            case "java.lang.Integer": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.INTEGER, buffer -> buffer.putInt((Integer)v));
            }
            case "java.math.BigInteger": {
                BigInteger bigInteger = (BigInteger)v;
                return ByteString.copyFrom((byte[])bigInteger.toByteArray());
            }
            case "java.lang.Long": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.LONG, buffer -> buffer.putLong((Long)v));
            }
            case "java.lang.Short": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.SHORT, buffer -> buffer.putShort((Short)v));
            }
            case "java.lang.Float": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.FLOAT, buffer -> buffer.putFloat(((Float)v).floatValue()));
            }
            case "java.lang.Double": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.DOUBLE, buffer -> buffer.putDouble((Double)v));
            }
            case "java.math.BigDecimal": {
                BigDecimal bigDecimal = (BigDecimal)v;
                return ByteString.copyFromUtf8((String)bigDecimal.toString());
            }
            case "java.util.BitSet": {
                BitSet bitSet = (BitSet)v;
                return ByteString.copyFrom((byte[])bitSet.toByteArray());
            }
            case "java.lang.Boolean": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.SHORT, buffer -> {
                    Boolean b = (Boolean)v;
                    buffer.putShort((short)(b != false ? 1 : 0));
                });
            }
            case "java.time.LocalDateTime": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.LONG, buffer -> buffer.putLong(Timestamp.valueOf((LocalDateTime)v).getTime()));
            }
            case "oracle.sql.TIMESTAMP": {
                return BinlogMessageUtil.allocateByteBufferToByteString(BinlogByteEnum.LONG, buffer -> {
                    TIMESTAMP timeStamp = (TIMESTAMP)v;
                    try {
                        buffer.putLong(timeStamp.timestampValue().getTime());
                    }
                    catch (SQLException e) {
                        logger.error(e.getMessage());
                    }
                });
            }
            case "oracle.sql.BLOB": {
                return ByteString.copyFrom((byte[])BinlogMessageUtil.getBytes((BLOB)v));
            }
            case "oracle.sql.CLOB": {
                return ByteString.copyFrom((byte[])BinlogMessageUtil.getBytes((CLOB)v));
            }
            case "oracle.sql.STRUCT": {
                return ByteString.copyFrom((byte[])BinlogMessageUtil.getBytes((STRUCT)v));
            }
        }
        logger.error("Unsupported serialize value type:{}", (Object)type);
        return null;
    }

    public static Object deserializeValue(int type, ByteString v) {
        BinlogColumnValue value = new BinlogColumnValue(v);
        if (value.isNull()) {
            return null;
        }
        switch (type) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return value.asString();
            }
            case 93: {
                return value.asTimestamp();
            }
            case 92: {
                return value.asTime();
            }
            case 91: {
                return value.asDate();
            }
            case -6: 
            case 4: {
                return value.asInteger();
            }
            case 5: {
                return value.asShort();
            }
            case -5: {
                return value.asLong();
            }
            case 6: 
            case 7: {
                return value.asFloat();
            }
            case 8: {
                return value.asDouble();
            }
            case 2: 
            case 3: {
                return value.asBigDecimal();
            }
            case 16: {
                return value.asBoolean();
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2004: 
            case 2005: 
            case 2011: {
                return value.asByteArray();
            }
            case -8: {
                return null;
            }
        }
        return null;
    }

    private static ByteString allocateByteBufferToByteString(BinlogByteEnum byteType, ByteStringMapper mapper) {
        ByteBuffer buffer = ByteBuffer.allocate(byteType.getByteLength());
        mapper.apply(buffer);
        buffer.flip();
        return ByteString.copyFrom((ByteBuffer)buffer, (int)byteType.getByteLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(BLOB blob) {
        InputStream is = null;
        byte[] b = null;
        try {
            is = blob.getBinaryStream();
            b = new byte[(int)blob.length()];
            int read = is.read(b);
            if (-1 == read) {
                byte[] byArray = b;
                return byArray;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return b;
    }

    private static byte[] getBytes(CLOB clob) {
        try {
            long length = clob.length();
            if (length > 0L) {
                return clob.getSubString(1L, (int)length).getBytes(Charset.defaultCharset());
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return new byte[0];
    }

    private static byte[] getBytes(STRUCT v) {
        try {
            return v.toBytes();
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            throw new StorageException(e);
        }
    }

    static interface ByteStringMapper {
        public void apply(ByteBuffer var1);
    }
}

