/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.connector.database.AbstractDatabaseConnector;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.enums.SqlBuilderEnum;
import org.dbsyncer.sdk.enums.TableTypeEnum;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.PageSql;
import org.dbsyncer.sdk.model.SqlTable;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;

public abstract class AbstractDQLConnector
extends AbstractDatabaseConnector {
    @Override
    public List<Table> getTable(DatabaseConnectorInstance connectorInstance) {
        DatabaseConfig cfg = connectorInstance.getConfig();
        List<SqlTable> sqlTables = cfg.getSqlTables();
        ArrayList<Table> tables = new ArrayList<Table>();
        if (!CollectionUtils.isEmpty(sqlTables)) {
            sqlTables.forEach(s -> tables.add(new Table(s.getSqlName(), TableTypeEnum.TABLE.getCode(), Collections.EMPTY_LIST, s.getSql())));
        }
        return tables;
    }

    @Override
    public Map<String, String> getSourceCommand(CommandConfig commandConfig) {
        return this.getDqlSourceCommand(commandConfig, false);
    }

    @Override
    public MetaInfo getMetaInfo(DatabaseConnectorInstance connectorInstance, String sqlName) {
        DatabaseConfig cfg = connectorInstance.getConfig();
        List<SqlTable> sqlTables = cfg.getSqlTables();
        for (SqlTable s : sqlTables) {
            if (!StringUtil.equals((CharSequence)s.getSqlName(), (CharSequence)sqlName)) continue;
            String sql = s.getSql().toUpperCase();
            sql = sql.replace("\t", " ");
            sql = sql.replace("\r", " ");
            String queryMetaSql = StringUtil.contains((CharSequence)(sql = sql.replace("\n", " ")), (CharSequence)" WHERE ") ? s.getSql() + " AND 1!=1 " : s.getSql() + " WHERE 1!=1 ";
            return (MetaInfo)connectorInstance.execute(databaseTemplate -> super.getMetaInfo(databaseTemplate, queryMetaSql, this.getSchema(cfg), s.getTable()));
        }
        return null;
    }

    protected Map<String, String> getDqlSourceCommand(CommandConfig commandConfig, boolean groupByPK) {
        String queryFilterSql = this.getQueryFilterSql(commandConfig);
        Table table = commandConfig.getTable();
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> primaryKeys = PrimaryKeyUtil.findTablePrimaryKeys(table);
        if (CollectionUtils.isEmpty(primaryKeys)) {
            return map;
        }
        String querySql = table.getSql();
        if (StringUtil.isNotBlank((CharSequence)queryFilterSql)) {
            querySql = querySql + queryFilterSql;
        }
        PageSql pageSql = new PageSql(querySql, "", primaryKeys, table.getColumn());
        map.put(SqlBuilderEnum.QUERY.getName(), this.getPageSql(pageSql));
        StringBuilder queryCount = new StringBuilder();
        queryCount.append("SELECT COUNT(1) FROM (").append(querySql);
        if (groupByPK) {
            queryCount.append(" GROUP BY ");
            String quotation = this.buildSqlWithQuotation();
            PrimaryKeyUtil.buildSql(queryCount, primaryKeys, quotation, ",", "", true);
        }
        queryCount.append(") DBSYNCER_T");
        map.put(SqlBuilderEnum.QUERY_COUNT.getName(), queryCount.toString());
        return map;
    }
}

