/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.DDLConfig;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.config.SqlBuilderConfig;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.connector.AbstractConnector;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.connector.database.Database;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.connector.database.DatabaseTemplate;
import org.dbsyncer.sdk.connector.database.ds.SimpleConnection;
import org.dbsyncer.sdk.enums.OperationEnum;
import org.dbsyncer.sdk.enums.QuartzFilterEnum;
import org.dbsyncer.sdk.enums.SqlBuilderEnum;
import org.dbsyncer.sdk.enums.TableTypeEnum;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.Filter;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.PageSql;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.dbsyncer.sdk.util.DatabaseUtil;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.support.rowset.ResultSetWrappingSqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.util.Assert;

public abstract class AbstractDatabaseConnector
extends AbstractConnector
implements ConnectorService<DatabaseConnectorInstance, DatabaseConfig>,
Database {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String SYS_EXPRESSION = "^[$].*[$]$";

    @Override
    public boolean isSupportedTiming() {
        return true;
    }

    @Override
    public boolean isSupportedLog() {
        return true;
    }

    @Override
    public Class<DatabaseConfig> getConfigClass() {
        return DatabaseConfig.class;
    }

    @Override
    public ConnectorInstance connect(DatabaseConfig config) {
        return new DatabaseConnectorInstance(config);
    }

    @Override
    public void disconnect(DatabaseConnectorInstance connectorInstance) {
        connectorInstance.close();
    }

    @Override
    public boolean isAlive(DatabaseConnectorInstance connectorInstance) {
        Integer count = (Integer)connectorInstance.execute(databaseTemplate -> databaseTemplate.queryForObject(this.getValidationQuery(), Integer.class));
        return null != count && count > 0;
    }

    @Override
    public String getConnectorInstanceCacheKey(DatabaseConfig config) {
        return String.format("%s-%s-%s", config.getConnectorType(), config.getUrl(), config.getUsername());
    }

    @Override
    public List<Table> getTable(DatabaseConnectorInstance connectorInstance) {
        return this.getTable(connectorInstance, null, this.getSchema(connectorInstance.getConfig()), null);
    }

    @Override
    public MetaInfo getMetaInfo(DatabaseConnectorInstance connectorInstance, String tableNamePattern) {
        ArrayList<Field> fields = new ArrayList<Field>();
        String schema = this.getSchema(connectorInstance.getConfig());
        connectorInstance.execute(databaseTemplate -> {
            SimpleConnection connection = databaseTemplate.getSimpleConnection();
            Connection conn = connection.getConnection();
            String catalog = conn.getCatalog();
            String schemaNamePattern = null == schema ? conn.getSchema() : schema;
            DatabaseMetaData metaData = conn.getMetaData();
            List<String> primaryKeys = this.findTablePrimaryKeys(metaData, catalog, schemaNamePattern, tableNamePattern);
            ResultSet columnMetadata = metaData.getColumns(catalog, schemaNamePattern, tableNamePattern, null);
            while (columnMetadata.next()) {
                String columnName = columnMetadata.getString(4);
                int columnType = columnMetadata.getInt(5);
                String typeName = columnMetadata.getString(6);
                int columnSize = columnMetadata.getInt(7);
                int ratio = columnMetadata.getInt(9);
                fields.add(new Field(columnName, typeName, columnType, primaryKeys.contains(columnName), columnSize, ratio));
            }
            return fields;
        });
        return new MetaInfo().setColumn(fields);
    }

    @Override
    public long getCount(DatabaseConnectorInstance connectorInstance, Map<String, String> command) {
        if (CollectionUtils.isEmpty(command)) {
            return 0L;
        }
        String queryCountSql = command.get("QUERY_COUNT");
        if (StringUtil.isBlank((CharSequence)queryCountSql)) {
            return 0L;
        }
        try {
            return (Long)connectorInstance.execute(databaseTemplate -> {
                Long count = databaseTemplate.queryForObject(queryCountSql, Long.class);
                return count == null ? 0L : count;
            });
        }
        catch (EmptyResultDataAccessException e) {
            return 0L;
        }
    }

    @Override
    public Result reader(DatabaseConnectorInstance connectorInstance, ReaderConfig config) {
        boolean supportedCursor = this.enableCursor() && config.isSupportedCursor() && null != config.getCursors();
        String queryKey = supportedCursor ? "QUERY_CURSOR" : "QUERY";
        String querySql = config.getCommand().get(queryKey);
        Assert.hasText((String)querySql, (String)"\u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a.");
        Collections.addAll(config.getArgs(), supportedCursor ? this.getPageCursorArgs(config) : this.getPageArgs(config));
        List list = (List)connectorInstance.execute(databaseTemplate -> databaseTemplate.queryForList(querySql, config.getArgs().toArray()));
        return new Result(list);
    }

    @Override
    public Result writer(DatabaseConnectorInstance connectorInstance, WriterBatchConfig config) {
        String event = config.getEvent();
        List<Map> data = config.getData();
        String executeSql = config.getCommand().get(event);
        Assert.hasText((String)executeSql, (String)"\u6267\u884cSQL\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a.");
        if (CollectionUtils.isEmpty(config.getFields())) {
            this.logger.error("writer fields can not be empty.");
            throw new SdkException("writer fields can not be empty.");
        }
        if (CollectionUtils.isEmpty(data)) {
            this.logger.error("writer data can not be empty.");
            throw new SdkException("writer data can not be empty.");
        }
        ArrayList<Field> fields = new ArrayList<Field>(config.getFields());
        List<Field> pkFields = PrimaryKeyUtil.findConfigPrimaryKeyFields(config);
        if (!this.isInsert(event)) {
            if (this.isDelete(event)) {
                fields.clear();
            } else if (this.isUpdate(event)) {
                this.removeFieldWithPk(fields, pkFields);
            }
            fields.addAll(pkFields);
        }
        Result result = new Result();
        int[] execute = null;
        try {
            execute = (int[])connectorInstance.execute(databaseTemplate -> databaseTemplate.batchUpdate(executeSql, this.batchRows(fields, data)));
        }
        catch (Exception e) {
            data.forEach(row -> this.forceUpdate(result, connectorInstance, config, pkFields, (Map)row));
        }
        if (null != execute) {
            int batchSize = execute.length;
            for (int i = 0; i < batchSize; ++i) {
                if (execute[i] == 1 || execute[i] == -2) {
                    result.getSuccessData().add(data.get(i));
                    continue;
                }
                this.forceUpdate(result, connectorInstance, config, pkFields, data.get(i));
            }
        }
        return result;
    }

    @Override
    public Map<String, String> getSourceCommand(CommandConfig commandConfig) {
        Table table = commandConfig.getTable();
        List<String> primaryKeys = PrimaryKeyUtil.findTablePrimaryKeys(table);
        if (CollectionUtils.isEmpty(primaryKeys)) {
            return new HashMap<String, String>();
        }
        String tableName = table.getName();
        if (StringUtil.isBlank((CharSequence)tableName)) {
            this.logger.error("\u6570\u636e\u6e90\u8868\u4e0d\u80fd\u4e3a\u7a7a.");
            throw new SdkException("\u6570\u636e\u6e90\u8868\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String schema = this.getSchemaWithQuotation((DatabaseConfig)commandConfig.getConnectorConfig());
        List<Field> column = this.filterColumn(table.getColumn());
        String queryFilterSql = this.getQueryFilterSql(commandConfig);
        SqlBuilderConfig config = new SqlBuilderConfig(this, schema, tableName, primaryKeys, column, queryFilterSql);
        HashMap<String, String> map = new HashMap<String, String>();
        this.buildSql(map, SqlBuilderEnum.QUERY, config);
        if (this.enableCursor()) {
            this.buildSql(map, SqlBuilderEnum.QUERY_CURSOR, config);
        }
        map.put("QUERY_COUNT", this.getQueryCountSql(commandConfig, primaryKeys, schema, queryFilterSql));
        return map;
    }

    @Override
    public Map<String, String> getTargetCommand(CommandConfig commandConfig) {
        Table table = commandConfig.getTable();
        List<String> primaryKeys = PrimaryKeyUtil.findTablePrimaryKeys(table);
        if (CollectionUtils.isEmpty(primaryKeys)) {
            return new HashMap<String, String>();
        }
        String tableName = table.getName();
        if (StringUtil.isBlank((CharSequence)tableName)) {
            this.logger.error("\u76ee\u6807\u6e90\u8868\u4e0d\u80fd\u4e3a\u7a7a.");
            throw new SdkException("\u76ee\u6807\u6e90\u8868\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String schema = this.getSchemaWithQuotation((DatabaseConfig)commandConfig.getConnectorConfig());
        List<Field> column = this.filterColumn(table.getColumn());
        SqlBuilderConfig config = new SqlBuilderConfig(this, schema, tableName, primaryKeys, column, null);
        HashMap<String, String> map = new HashMap<String, String>();
        this.buildSql(map, SqlBuilderEnum.INSERT, config);
        this.buildSql(map, SqlBuilderEnum.UPDATE, config);
        this.buildSql(map, SqlBuilderEnum.DELETE, config);
        this.buildSql(map, SqlBuilderEnum.QUERY_EXIST, config);
        return map;
    }

    protected String getSchema(DatabaseConfig config) {
        return config.getSchema();
    }

    protected String getSchemaWithQuotation(DatabaseConfig config) {
        StringBuilder schema = new StringBuilder();
        if (StringUtil.isNotBlank((CharSequence)config.getSchema())) {
            String quotation = this.buildSqlWithQuotation();
            schema.append(quotation).append(config.getSchema()).append(quotation).append(".").toString();
        }
        return schema.toString();
    }

    protected void appendOrderByPk(PageSql config, StringBuilder sql) {
        if (!CollectionUtils.isEmpty(config.getPrimaryKeys()) && config.getPrimaryKeys().size() == 1) {
            sql.append(" ORDER BY ");
            String quotation = this.buildSqlWithQuotation();
            PrimaryKeyUtil.buildSql(sql, config.getPrimaryKeys(), quotation, ",", "", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetaInfo getMetaInfo(DatabaseTemplate databaseTemplate, String metaSql, String schema, String tableName) throws SQLException {
        SqlRowSet sqlRowSet = databaseTemplate.queryForRowSet(metaSql);
        ResultSetWrappingSqlRowSet rowSet = (ResultSetWrappingSqlRowSet)sqlRowSet;
        SqlRowSetMetaData metaData = rowSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (1 > columnCount) {
            throw new SdkException("\u67e5\u8be2\u8868\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        ArrayList<Field> fields = new ArrayList<Field>(columnCount);
        HashMap<String, List<String>> tables = new HashMap<String, List<String>>();
        try {
            SimpleConnection connection = databaseTemplate.getSimpleConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog();
            schema = StringUtil.isNotBlank((CharSequence)schema) ? schema : null;
            String name = null;
            String label = null;
            String typeName = null;
            String table = null;
            for (int i = 1; i <= columnCount; ++i) {
                String string = table = StringUtil.isNotBlank((CharSequence)tableName) ? tableName : metaData.getTableName(i);
                if (null == tables.get(table)) {
                    tables.putIfAbsent(table, this.findTablePrimaryKeys(md, catalog, schema, table));
                }
                name = metaData.getColumnName(i);
                label = metaData.getColumnLabel(i);
                typeName = metaData.getColumnTypeName(i);
                int columnType = metaData.getColumnType(i);
                boolean pk = this.isPk(tables, table, name);
                fields.add(new Field(label, typeName, columnType, pk));
            }
        }
        finally {
            tables.clear();
        }
        return new MetaInfo().setColumn(fields);
    }

    protected String getQueryCountSql(CommandConfig commandConfig, List<String> primaryKeys, String schema, String queryFilterSql) {
        Table table = commandConfig.getTable();
        String tableName = table.getName();
        SqlBuilderConfig config = new SqlBuilderConfig(this, schema, tableName, primaryKeys, table.getColumn(), queryFilterSql);
        return SqlBuilderEnum.QUERY_COUNT.getSqlBuilder().buildSql(config);
    }

    protected String getQueryFilterSql(CommandConfig commandConfig) {
        String orSql;
        List<Filter> filter = commandConfig.getFilter();
        if (CollectionUtils.isEmpty(filter)) {
            return "";
        }
        Table table = commandConfig.getTable();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        table.getColumn().forEach(field -> fieldMap.put(field.getName(), (Field)field));
        StringBuilder sql = new StringBuilder();
        String addSql = this.buildFilterSql(fieldMap, OperationEnum.AND.getName(), filter);
        if (StringUtil.isNotBlank((CharSequence)addSql)) {
            sql.append(addSql);
        }
        if (StringUtil.isNotBlank((CharSequence)(orSql = this.buildFilterSql(fieldMap, OperationEnum.OR.getName(), filter))) && StringUtil.isNotBlank((CharSequence)addSql)) {
            sql.append(" OR ");
        }
        sql.append(orSql);
        if (StringUtil.isNotBlank((CharSequence)sql.toString())) {
            sql.insert(0, " WHERE ");
        }
        return sql.toString();
    }

    private List<Field> filterColumn(List<Field> column) {
        HashSet<String> mark = new HashSet<String>();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field c : column) {
            String name = c.getName();
            if (StringUtil.isBlank((CharSequence)name)) {
                throw new SdkException("The field name can not be empty.");
            }
            if (mark.contains(name)) continue;
            fields.add(c);
            mark.add(name);
        }
        return fields;
    }

    private List<Table> getTable(DatabaseConnectorInstance connectorInstance, String catalog, String schema, String tableNamePattern) {
        return (List)connectorInstance.execute(databaseTemplate -> {
            ArrayList<Table> tables = new ArrayList<Table>();
            SimpleConnection connection = databaseTemplate.getSimpleConnection();
            Connection conn = connection.getConnection();
            String databaseCatalog = null == catalog ? conn.getCatalog() : catalog;
            String schemaNamePattern = null == schema ? conn.getSchema() : schema;
            String[] types = new String[]{TableTypeEnum.TABLE.getCode(), TableTypeEnum.VIEW.getCode(), TableTypeEnum.MATERIALIZED_VIEW.getCode()};
            ResultSet rs = conn.getMetaData().getTables(databaseCatalog, schemaNamePattern, tableNamePattern, types);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                tables.add(new Table(tableName, tableType));
            }
            return tables;
        });
    }

    private String buildFilterSql(Map<String, Field> fieldMap, String queryOperator, List<Filter> filter) {
        List list = filter.stream().filter(f -> StringUtil.equals((CharSequence)f.getOperation(), (CharSequence)queryOperator)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        int size = list.size();
        int end = size - 1;
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        Filter c = null;
        String quotation = this.buildSqlWithQuotation();
        for (int i = 0; i < size; ++i) {
            c = (Filter)list.get(i);
            Field field = fieldMap.get(c.getName());
            Assert.notNull((Object)field, (String)"\u6761\u4ef6\u5b57\u6bb5\u65e0\u6548.");
            sql.append(quotation);
            sql.append(this.buildFieldName(field));
            sql.append(quotation);
            sql.append(" ").append(c.getFilter()).append(" ");
            sql.append(this.buildFilterValue(c.getValue()));
            if (i >= end) continue;
            sql.append(" ").append(queryOperator).append(" ");
        }
        sql.append(")");
        return sql.toString();
    }

    protected String buildFilterValue(String value) {
        Matcher matcher;
        if (StringUtil.isNotBlank((CharSequence)value) && QuartzFilterEnum.getQuartzFilterEnum(value) == null && (matcher = Pattern.compile("^[$].*[$]$").matcher(value)).find()) {
            return StringUtil.substring((String)value, (int)1, (int)(value.length() - 1));
        }
        return "'" + value + "'";
    }

    private void buildSql(Map<String, String> map, SqlBuilderEnum builderType, SqlBuilderConfig config) {
        map.put(builderType.getName(), builderType.getSqlBuilder().buildSql(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findTablePrimaryKeys(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        ResultSet rs = null;
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try {
            rs = md.getPrimaryKeys(catalog, schema, tableName);
            while (rs.next()) {
                primaryKeys.add(rs.getString("COLUMN_NAME"));
            }
        }
        catch (Throwable throwable) {
            DatabaseUtil.close(rs);
            throw throwable;
        }
        DatabaseUtil.close(rs);
        return primaryKeys;
    }

    private List<Object[]> batchRows(List<Field> fields, List<Map> data) {
        return data.stream().map(row -> this.batchRow(fields, (Map)row)).collect(Collectors.toList());
    }

    private Object[] batchRow(List<Field> fields, Map row) {
        int size = fields.size();
        Object[] args = new Object[size];
        for (int i = 0; i < size; ++i) {
            args[i] = row.get(fields.get(i).getName());
        }
        return args;
    }

    private void forceUpdate(Result result, DatabaseConnectorInstance connectorInstance, WriterBatchConfig config, List<Field> pkFields, Map row) {
        if (this.isUpdate(config.getEvent()) || this.isInsert(config.getEvent())) {
            String queryCount = config.getCommand().get("QUERY_COUNT_EXIST");
            int size = pkFields.size();
            Object[] args = new Object[size];
            for (int i = 0; i < size; ++i) {
                args[i] = row.get(pkFields.get(i).getName());
            }
            String event = this.existRow(connectorInstance, queryCount, args) ? "UPDATE" : "INSERT";
            this.logger.warn("{}\u8868\u6267\u884c{}\u5931\u8d25, \u91cd\u65b0\u6267\u884c{}, {}", new Object[]{config.getTableName(), config.getEvent(), event, row});
            this.writer(result, connectorInstance, config, pkFields, row, event);
        }
    }

    private void writer(Result result, DatabaseConnectorInstance connectorInstance, WriterBatchConfig config, List<Field> pkFields, Map row, String event) {
        String sql = config.getCommand().get(event);
        ArrayList<Field> fields = new ArrayList<Field>(config.getFields());
        if (!this.isInsert(event)) {
            if (this.isDelete(event)) {
                fields.clear();
            } else if (this.isUpdate(event)) {
                this.removeFieldWithPk(fields, pkFields);
            }
            fields.addAll(pkFields);
        }
        try {
            int execute = (Integer)connectorInstance.execute(databaseTemplate -> databaseTemplate.update(sql, this.batchRow(fields, row)));
            if (execute == 0) {
                throw new SdkException(String.format("\u5c1d\u8bd5\u6267\u884c[%s]\u5931\u8d25", event));
            }
            result.getSuccessData().add(row);
        }
        catch (Exception e) {
            result.getFailData().add(row);
            result.getError().append("SQL:").append(sql).append(System.lineSeparator()).append("DATA:").append(row).append(System.lineSeparator()).append("ERROR:").append(e.getMessage()).append(System.lineSeparator());
            this.logger.error("\u6267\u884c{}\u5931\u8d25: {}, DATA:{}", new Object[]{event, e.getMessage(), row});
        }
    }

    private boolean existRow(DatabaseConnectorInstance connectorInstance, String sql, Object[] args) {
        int rowNum = 0;
        try {
            rowNum = (Integer)connectorInstance.execute(databaseTemplate -> databaseTemplate.queryForObject(sql, Integer.class, args));
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u67e5\u6570\u636e\u884c\u5b58\u5728\u5f02\u5e38:{}\uff0cSQL:{},\u53c2\u6570:{}", new Object[]{e.getMessage(), sql, args});
        }
        return rowNum > 0;
    }

    private boolean isPk(Map<String, List<String>> tables, String tableName, String name) {
        List<String> pk = tables.get(tableName);
        return !CollectionUtils.isEmpty(pk) && pk.contains(name);
    }

    private void removeFieldWithPk(List<Field> fields, List<Field> pkFields) {
        if (CollectionUtils.isEmpty(fields) || CollectionUtils.isEmpty(pkFields)) {
            return;
        }
        pkFields.forEach(pkField -> {
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                Field next = (Field)iterator.next();
                if (next == null || !StringUtil.equals((CharSequence)next.getName(), (CharSequence)pkField.getName())) continue;
                iterator.remove();
                break;
            }
        });
    }

    @Override
    public Result writerDDL(DatabaseConnectorInstance connectorInstance, DDLConfig config) {
        Result result = new Result();
        try {
            Assert.hasText((String)config.getSql(), (String)"\u6267\u884cSQL\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a.");
            connectorInstance.execute(databaseTemplate -> {
                databaseTemplate.execute("/*dbs*/".concat(config.getSql()));
                return true;
            });
            HashMap<String, String> successMap = new HashMap<String, String>();
            successMap.put("sql", config.getSql());
            result.addSuccessData(Collections.singletonList(successMap));
        }
        catch (Exception e) {
            result.getError().append(String.format("\u6267\u884cddl: %s, \u5f02\u5e38\uff1a%s", config.getSql(), e.getMessage()));
        }
        return result;
    }
}

