/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.database.ds.SimpleConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.ArgumentTypePreparedStatementSetter;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.InterruptibleBatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.ResultSetSupportingSqlParameter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.core.SqlReturnType;
import org.springframework.jdbc.core.SqlReturnUpdateCount;
import org.springframework.jdbc.core.SqlRowSetResultSetExtractor;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

public class DatabaseTemplate
implements JdbcOperations {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SimpleConnection connection;
    private final SQLExceptionTranslator exceptionTranslator = new SQLStateSQLExceptionTranslator();
    private static final String RETURN_RESULT_SET_PREFIX = "#result-set-";
    private static final String RETURN_UPDATE_COUNT_PREFIX = "#update-count-";
    private boolean ignoreWarnings = true;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    private boolean skipResultsProcessing = false;
    private boolean skipUndeclaredResults = false;
    private boolean resultsMapCaseInsensitive = false;

    public DatabaseTemplate(SimpleConnection connection) {
        this.connection = connection;
    }

    public SimpleConnection getSimpleConnection() {
        return this.connection;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setSkipResultsProcessing(boolean skipResultsProcessing) {
        this.skipResultsProcessing = skipResultsProcessing;
    }

    public boolean isSkipResultsProcessing() {
        return this.skipResultsProcessing;
    }

    public void setSkipUndeclaredResults(boolean skipUndeclaredResults) {
        this.skipUndeclaredResults = skipUndeclaredResults;
    }

    public boolean isSkipUndeclaredResults() {
        return this.skipUndeclaredResults;
    }

    public void setResultsMapCaseInsensitive(boolean resultsMapCaseInsensitive) {
        this.resultsMapCaseInsensitive = resultsMapCaseInsensitive;
    }

    public boolean isResultsMapCaseInsensitive() {
        return this.resultsMapCaseInsensitive;
    }

    @Nullable
    public <T> T execute(ConnectionCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        try {
            return (T)action.doInConnection((Connection)this.connection);
        }
        catch (SQLException ex) {
            String sql = DatabaseTemplate.getSql(action);
            throw this.translateException("ConnectionCallback", sql, ex);
        }
    }

    protected Connection createConnectionProxy(Connection con) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(con));
    }

    @Nullable
    private <T> T execute(StatementCallback<T> action, boolean closeResources) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            this.applyStatementSettings(stmt);
            Object result = action.doInStatement(stmt);
            this.handleWarnings(stmt);
            Object object = result;
            return (T)object;
        }
        catch (SQLException ex) {
            String sql = DatabaseTemplate.getSql(action);
            JdbcUtils.closeStatement((Statement)stmt);
            stmt = null;
            throw this.translateException("StatementCallback", sql, ex);
        }
        finally {
            if (closeResources) {
                JdbcUtils.closeStatement((Statement)stmt);
            }
        }
    }

    @Nullable
    public <T> T execute(StatementCallback<T> action) throws DataAccessException {
        return this.execute(action, true);
    }

    public void execute(final String sql) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL statement [" + sql + "]");
        }
        class ExecuteStatementCallback
        implements StatementCallback<Object>,
        SqlProvider {
            ExecuteStatementCallback() {
            }

            @Nullable
            public Object doInStatement(Statement stmt) throws SQLException {
                stmt.execute(sql);
                return null;
            }

            public String getSql() {
                return sql;
            }
        }
        this.execute(new ExecuteStatementCallback(), true);
    }

    @Nullable
    public <T> T query(final String sql, final ResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"SQL must not be null");
        Assert.notNull(rse, (String)"ResultSetExtractor must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL query [" + sql + "]");
        }
        class QueryStatementCallback
        implements StatementCallback<T>,
        SqlProvider {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public T doInStatement(Statement stmt) throws SQLException {
                Object object;
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery(sql);
                    object = rse.extractData(rs);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                return object;
            }

            public String getSql() {
                return sql;
            }
        }
        return this.execute(new QueryStatementCallback(), true);
    }

    public void query(String sql, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, new RowCallbackHandlerResultSetExtractor(rch));
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)DatabaseTemplate.result(this.query(sql, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper)));
    }

    public <T> Stream<T> queryForStream(final String sql, final RowMapper<T> rowMapper) throws DataAccessException {
        class StreamStatementCallback
        implements StatementCallback<Stream<T>>,
        SqlProvider {
            StreamStatementCallback() {
            }

            public Stream<T> doInStatement(Statement stmt) throws SQLException {
                ResultSet rs = stmt.executeQuery(sql);
                return (Stream)new ResultSetSpliterator(rs, rowMapper).stream().onClose(() -> {
                    JdbcUtils.closeResultSet((ResultSet)rs);
                    JdbcUtils.closeStatement((Statement)stmt);
                });
            }

            public String getSql() {
                return sql;
            }
        }
        return (Stream)DatabaseTemplate.result(this.execute(new StreamStatementCallback(), false));
    }

    public Map<String, Object> queryForMap(String sql) throws DataAccessException {
        return DatabaseTemplate.result(this.queryForObject(sql, this.getColumnMapRowMapper()));
    }

    @Nullable
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        List<T> results = this.query(sql, rowMapper);
        return (T)DataAccessUtils.nullableSingleResult(results);
    }

    @Nullable
    public <T> T queryForObject(String sql, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, this.getSingleColumnRowMapper(requiredType));
    }

    public <T> List<T> queryForList(String sql, Class<T> elementType) throws DataAccessException {
        return this.query(sql, this.getSingleColumnRowMapper(elementType));
    }

    public List<Map<String, Object>> queryForList(String sql) throws DataAccessException {
        return this.query(sql, this.getColumnMapRowMapper());
    }

    public SqlRowSet queryForRowSet(String sql) throws DataAccessException {
        return (SqlRowSet)DatabaseTemplate.result(this.query(sql, (ResultSetExtractor)new SqlRowSetResultSetExtractor()));
    }

    public int update(final String sql) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"SQL must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL update [" + sql + "]");
        }
        class UpdateStatementCallback
        implements StatementCallback<Integer>,
        SqlProvider {
            UpdateStatementCallback() {
            }

            public Integer doInStatement(Statement stmt) throws SQLException {
                int rows = stmt.executeUpdate(sql);
                if (DatabaseTemplate.this.logger.isTraceEnabled()) {
                    DatabaseTemplate.this.logger.trace("SQL update affected " + rows + " rows");
                }
                return rows;
            }

            public String getSql() {
                return sql;
            }
        }
        return DatabaseTemplate.updateCount(this.execute(new UpdateStatementCallback(), true));
    }

    public int[] batchUpdate(final String ... sql) throws DataAccessException {
        int[] result;
        Assert.notEmpty((Object[])sql, (String)"SQL array must not be empty");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL batch update of " + sql.length + " statements");
        }
        class BatchUpdateStatementCallback
        implements StatementCallback<int[]>,
        SqlProvider {
            @Nullable
            private String currSql;

            BatchUpdateStatementCallback() {
            }

            public int[] doInStatement(Statement stmt) throws SQLException, DataAccessException {
                int[] rowsAffected = new int[sql.length];
                if (JdbcUtils.supportsBatchUpdates((Connection)stmt.getConnection())) {
                    for (String sqlStmt : sql) {
                        this.currSql = this.appendSql(this.currSql, sqlStmt);
                        stmt.addBatch(sqlStmt);
                    }
                    try {
                        rowsAffected = stmt.executeBatch();
                    }
                    catch (BatchUpdateException ex) {
                        String batchExceptionSql = null;
                        for (int i = 0; i < ex.getUpdateCounts().length; ++i) {
                            if (ex.getUpdateCounts()[i] != -3) continue;
                            batchExceptionSql = this.appendSql(batchExceptionSql, sql[i]);
                        }
                        if (StringUtils.hasLength(batchExceptionSql)) {
                            this.currSql = batchExceptionSql;
                        }
                        throw ex;
                    }
                } else {
                    for (int i = 0; i < sql.length; ++i) {
                        this.currSql = sql[i];
                        if (stmt.execute(sql[i])) {
                            throw new InvalidDataAccessApiUsageException("Invalid batch SQL statement: " + sql[i]);
                        }
                        rowsAffected[i] = stmt.getUpdateCount();
                    }
                }
                return rowsAffected;
            }

            private String appendSql(@Nullable String sql2, String statement) {
                return StringUtils.hasLength((String)sql2) ? sql2 + "; " + statement : statement;
            }

            @Nullable
            public String getSql() {
                return this.currSql;
            }
        }
        Assert.state(((result = this.execute(new BatchUpdateStatementCallback(), true)) != null ? 1 : 0) != 0, (String)"No update counts");
        return result;
    }

    @Nullable
    private <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action, boolean closeResources) throws DataAccessException {
        Assert.notNull((Object)psc, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(action, (String)"Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            String sql = DatabaseTemplate.getSql(psc);
            this.logger.debug("Executing prepared SQL statement" + (sql != null ? " [" + sql + "]" : ""));
        }
        PreparedStatement ps = null;
        try {
            ps = psc.createPreparedStatement((Connection)this.connection);
            this.applyStatementSettings(ps);
            Object result = action.doInPreparedStatement(ps);
            this.handleWarnings(ps);
            Object object = result;
            return (T)object;
        }
        catch (SQLException ex) {
            if (psc instanceof ParameterDisposer) {
                ((ParameterDisposer)psc).cleanupParameters();
            }
            String sql = DatabaseTemplate.getSql(psc);
            psc = null;
            JdbcUtils.closeStatement((Statement)ps);
            ps = null;
            throw this.translateException("PreparedStatementCallback", sql, ex);
        }
        finally {
            if (closeResources) {
                if (psc instanceof ParameterDisposer) {
                    ((ParameterDisposer)psc).cleanupParameters();
                }
                JdbcUtils.closeStatement((Statement)ps);
            }
        }
    }

    @Nullable
    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(psc, action, true);
    }

    @Nullable
    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(new SimplePreparedStatementCreator(sql), action, true);
    }

    @Nullable
    public <T> T query(PreparedStatementCreator psc, final @Nullable PreparedStatementSetter pss, final ResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull(rse, (String)"ResultSetExtractor must not be null");
        this.logger.debug("Executing prepared SQL query");
        return this.execute(psc, new PreparedStatementCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public T doInPreparedStatement(PreparedStatement ps) throws SQLException {
                Object object;
                ResultSet rs = null;
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    rs = ps.executeQuery();
                    object = rse.extractData(rs);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)pss).cleanupParameters();
                    }
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)pss).cleanupParameters();
                }
                return object;
            }
        }, true);
    }

    @Nullable
    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(psc, null, rse);
    }

    @Nullable
    public <T> T query(String sql, @Nullable PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(new SimplePreparedStatementCreator(sql), pss, rse);
    }

    @Nullable
    public <T> T query(String sql, Object[] args, int[] argTypes, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql, this.newArgTypePreparedStatementSetter(args, argTypes), rse);
    }

    @Deprecated
    @Nullable
    public <T> T query(String sql, @Nullable Object[] args, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql, this.newArgPreparedStatementSetter(args), rse);
    }

    @Nullable
    public <T> T query(String sql, ResultSetExtractor<T> rse, Object ... args) throws DataAccessException {
        return this.query(sql, this.newArgPreparedStatementSetter(args), rse);
    }

    public void query(PreparedStatementCreator psc, RowCallbackHandler rch) throws DataAccessException {
        this.query(psc, new RowCallbackHandlerResultSetExtractor(rch));
    }

    public void query(String sql, @Nullable PreparedStatementSetter pss, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, pss, new RowCallbackHandlerResultSetExtractor(rch));
    }

    public void query(String sql, Object[] args, int[] argTypes, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, this.newArgTypePreparedStatementSetter(args, argTypes), rch);
    }

    @Deprecated
    public void query(String sql, @Nullable Object[] args, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, this.newArgPreparedStatementSetter(args), rch);
    }

    public void query(String sql, RowCallbackHandler rch, Object ... args) throws DataAccessException {
        this.query(sql, this.newArgPreparedStatementSetter(args), rch);
    }

    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)DatabaseTemplate.result(this.query(psc, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper)));
    }

    public <T> List<T> query(String sql, @Nullable PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)DatabaseTemplate.result(this.query(sql, pss, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper)));
    }

    public <T> List<T> query(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)DatabaseTemplate.result(this.query(sql, args, argTypes, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper)));
    }

    @Deprecated
    public <T> List<T> query(String sql, @Nullable Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)DatabaseTemplate.result(this.query(sql, args, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper)));
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return (List)DatabaseTemplate.result(this.query(sql, args, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper)));
    }

    public <T> Stream<T> queryForStream(PreparedStatementCreator psc, @Nullable PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException {
        return (Stream)DatabaseTemplate.result(this.execute(psc, ps -> {
            if (pss != null) {
                pss.setValues(ps);
            }
            ResultSet rs = ps.executeQuery();
            return (Stream)new ResultSetSpliterator(rs, rowMapper).stream().onClose(() -> {
                JdbcUtils.closeResultSet((ResultSet)rs);
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)pss).cleanupParameters();
                }
                JdbcUtils.closeStatement((Statement)ps);
            });
        }, false));
    }

    public <T> Stream<T> queryForStream(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForStream(psc, null, rowMapper);
    }

    public <T> Stream<T> queryForStream(String sql, @Nullable PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForStream(new SimplePreparedStatementCreator(sql), pss, rowMapper);
    }

    public <T> Stream<T> queryForStream(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.queryForStream(new SimplePreparedStatementCreator(sql), this.newArgPreparedStatementSetter(args), rowMapper);
    }

    @Nullable
    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        List results = (List)this.query(sql, args, argTypes, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper, 1));
        return (T)DataAccessUtils.nullableSingleResult((Collection)results);
    }

    @Deprecated
    @Nullable
    public <T> T queryForObject(String sql, @Nullable Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        List results = (List)this.query(sql, args, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper, 1));
        return (T)DataAccessUtils.nullableSingleResult((Collection)results);
    }

    @Nullable
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        List results = (List)this.query(sql, args, (ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper, 1));
        return (T)DataAccessUtils.nullableSingleResult((Collection)results);
    }

    @Nullable
    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, args, argTypes, this.getSingleColumnRowMapper(requiredType));
    }

    @Deprecated
    public <T> T queryForObject(String sql, @Nullable Object[] args, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, args, this.getSingleColumnRowMapper(requiredType));
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return this.queryForObject(sql, args, this.getSingleColumnRowMapper(requiredType));
    }

    public Map<String, Object> queryForMap(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return DatabaseTemplate.result(this.queryForObject(sql, args, argTypes, this.getColumnMapRowMapper()));
    }

    public Map<String, Object> queryForMap(String sql, Object ... args) throws DataAccessException {
        return DatabaseTemplate.result(this.queryForObject(sql, args, this.getColumnMapRowMapper()));
    }

    public <T> List<T> queryForList(String sql, Object[] args, int[] argTypes, Class<T> elementType) throws DataAccessException {
        return this.query(sql, args, argTypes, this.getSingleColumnRowMapper(elementType));
    }

    @Deprecated
    public <T> List<T> queryForList(String sql, @Nullable Object[] args, Class<T> elementType) throws DataAccessException {
        return this.query(sql, args, this.getSingleColumnRowMapper(elementType));
    }

    public <T> List<T> queryForList(String sql, Class<T> elementType, Object ... args) throws DataAccessException {
        return this.query(sql, args, this.getSingleColumnRowMapper(elementType));
    }

    public List<Map<String, Object>> queryForList(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return this.query(sql, args, argTypes, this.getColumnMapRowMapper());
    }

    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return this.query(sql, args, this.getColumnMapRowMapper());
    }

    public SqlRowSet queryForRowSet(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return (SqlRowSet)DatabaseTemplate.result(this.query(sql, args, argTypes, (ResultSetExtractor)new SqlRowSetResultSetExtractor()));
    }

    public SqlRowSet queryForRowSet(String sql, Object ... args) throws DataAccessException {
        return (SqlRowSet)DatabaseTemplate.result(this.query(sql, args, (ResultSetExtractor)new SqlRowSetResultSetExtractor()));
    }

    protected int update(PreparedStatementCreator psc, @Nullable PreparedStatementSetter pss) throws DataAccessException {
        this.logger.debug("Executing prepared SQL update");
        return DatabaseTemplate.updateCount((Integer)this.execute(psc, ps -> {
            try {
                if (pss != null) {
                    pss.setValues(ps);
                }
                int rows = ps.executeUpdate();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("SQL update affected " + rows + " rows");
                }
                Integer n = rows;
                return n;
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)pss).cleanupParameters();
                }
            }
        }, true));
    }

    public int update(PreparedStatementCreator psc) throws DataAccessException {
        return this.update(psc, (PreparedStatementSetter)null);
    }

    public int update(PreparedStatementCreator psc, KeyHolder generatedKeyHolder) throws DataAccessException {
        Assert.notNull((Object)generatedKeyHolder, (String)"KeyHolder must not be null");
        this.logger.debug("Executing SQL update and returning generated keys");
        return DatabaseTemplate.updateCount((Integer)this.execute(psc, ps -> {
            int rows = ps.executeUpdate();
            List generatedKeys = generatedKeyHolder.getKeyList();
            generatedKeys.clear();
            ResultSet keys = ps.getGeneratedKeys();
            if (keys != null) {
                try {
                    RowMapperResultSetExtractor rse = new RowMapperResultSetExtractor(this.getColumnMapRowMapper(), 1);
                    generatedKeys.addAll(DatabaseTemplate.result(rse.extractData(keys)));
                }
                finally {
                    JdbcUtils.closeResultSet((ResultSet)keys);
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("SQL update affected " + rows + " rows and returned " + generatedKeys.size() + " keys");
            }
            return rows;
        }, true));
    }

    public int update(String sql, @Nullable PreparedStatementSetter pss) throws DataAccessException {
        return this.update((PreparedStatementCreator)new SimplePreparedStatementCreator(sql), pss);
    }

    public int update(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return this.update(sql, this.newArgTypePreparedStatementSetter(args, argTypes));
    }

    public int update(String sql, Object ... args) throws DataAccessException {
        return this.update(sql, this.newArgPreparedStatementSetter(args));
    }

    public int[] batchUpdate(String sql, BatchPreparedStatementSetter pss) throws DataAccessException {
        int[] result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL batch update [" + sql + "]");
        }
        Assert.state(((result = (int[])this.execute(sql, ps -> {
            try {
                InterruptibleBatchPreparedStatementSetter ipss;
                int batchSize = pss.getBatchSize();
                InterruptibleBatchPreparedStatementSetter interruptibleBatchPreparedStatementSetter = ipss = pss instanceof InterruptibleBatchPreparedStatementSetter ? (InterruptibleBatchPreparedStatementSetter)pss : null;
                if (JdbcUtils.supportsBatchUpdates((Connection)ps.getConnection())) {
                    Object preparedStatement;
                    Long rowsProcessed;
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        if (ipss != null && ipss.isBatchExhausted(i)) break;
                        ps.addBatch();
                    }
                    int[] executeBatch = ps.executeBatch();
                    if (this.connection.isOracleDriver() && (long)batchSize != (rowsProcessed = (Long)this.invoke(preparedStatement = (Object)this.invoke(ps, 0, "preparedStatement"), 2, "rowsProcessed"))) {
                        Arrays.fill(executeBatch, 0);
                        int[] nArray = executeBatch;
                        return nArray;
                    }
                    preparedStatement = executeBatch;
                    return preparedStatement;
                }
                ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                for (int i = 0; i < batchSize; ++i) {
                    pss.setValues(ps, i);
                    if (ipss != null && ipss.isBatchExhausted(i)) break;
                    rowsAffected.add(ps.executeUpdate());
                }
                int[] rowsAffectedArray = new int[rowsAffected.size()];
                for (int i = 0; i < rowsAffectedArray.length; ++i) {
                    rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
                }
                int[] nArray = rowsAffectedArray;
                return nArray;
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)pss).cleanupParameters();
                }
            }
        })) != null ? 1 : 0) != 0, (String)"No result array");
        return result;
    }

    public int[] batchUpdate(String sql, List<Object[]> batchArgs) throws DataAccessException {
        return this.batchUpdate(sql, batchArgs, new int[0]);
    }

    public int[] batchUpdate(String sql, final List<Object[]> batchArgs, final int[] argTypes) throws DataAccessException {
        if (batchArgs.isEmpty()) {
            return new int[0];
        }
        return this.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values = (Object[])batchArgs.get(i);
                int colIndex = 0;
                for (Object value : values) {
                    ++colIndex;
                    if (value instanceof SqlParameterValue) {
                        SqlParameterValue paramValue = (SqlParameterValue)value;
                        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)colIndex, (SqlParameter)paramValue, (Object)paramValue.getValue());
                        continue;
                    }
                    int colType = argTypes.length < colIndex ? Integer.MIN_VALUE : argTypes[colIndex - 1];
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)colIndex, (int)colType, (Object)value);
                }
            }

            public int getBatchSize() {
                return batchArgs.size();
            }
        });
    }

    public <T> int[][] batchUpdate(String sql, Collection<T> batchArgs, int batchSize, ParameterizedPreparedStatementSetter<T> pss) throws DataAccessException {
        int[][] result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL batch update [" + sql + "] with a batch size of " + batchSize);
        }
        Assert.state(((result = (int[][])this.execute(sql, ps -> {
            ArrayList<int[]> rowsAffected = new ArrayList<int[]>();
            try {
                boolean batchSupported = JdbcUtils.supportsBatchUpdates((Connection)ps.getConnection());
                int n = 0;
                for (Object obj : batchArgs) {
                    pss.setValues(ps, obj);
                    ++n;
                    if (batchSupported) {
                        ps.addBatch();
                        if (n % batchSize != 0 && n != batchArgs.size()) continue;
                        if (this.logger.isTraceEnabled()) {
                            int batchIdx = n % batchSize == 0 ? n / batchSize : n / batchSize + 1;
                            int items = n - (n % batchSize == 0 ? n / batchSize - 1 : n / batchSize) * batchSize;
                            this.logger.trace("Sending SQL batch update #" + batchIdx + " with " + items + " items");
                        }
                        rowsAffected.add(ps.executeBatch());
                        continue;
                    }
                    int i = ps.executeUpdate();
                    rowsAffected.add(new int[]{i});
                }
                int[][] result1 = new int[rowsAffected.size()][];
                for (int i = 0; i < result1.length; ++i) {
                    result1[i] = (int[])rowsAffected.get(i);
                }
                int[][] nArrayArray = result1;
                return nArrayArray;
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)pss).cleanupParameters();
                }
            }
        })) != null ? 1 : 0) != 0, (String)"No result array");
        return result;
    }

    @Nullable
    public <T> T execute(CallableStatementCreator csc, CallableStatementCallback<T> action) throws DataAccessException {
        Assert.notNull((Object)csc, (String)"CallableStatementCreator must not be null");
        Assert.notNull(action, (String)"Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            String sql = DatabaseTemplate.getSql(csc);
            this.logger.debug("Calling stored procedure" + (sql != null ? " [" + sql + "]" : ""));
        }
        CallableStatement cs = null;
        try {
            cs = csc.createCallableStatement((Connection)this.connection);
            this.applyStatementSettings(cs);
            Object result = action.doInCallableStatement(cs);
            this.handleWarnings(cs);
            Object object = result;
            return (T)object;
        }
        catch (SQLException ex) {
            if (csc instanceof ParameterDisposer) {
                ((ParameterDisposer)csc).cleanupParameters();
            }
            String sql = DatabaseTemplate.getSql(csc);
            csc = null;
            JdbcUtils.closeStatement((Statement)cs);
            cs = null;
            throw this.translateException("CallableStatementCallback", sql, ex);
        }
        finally {
            if (csc instanceof ParameterDisposer) {
                ((ParameterDisposer)csc).cleanupParameters();
            }
            JdbcUtils.closeStatement((Statement)cs);
        }
    }

    @Nullable
    public <T> T execute(String callString, CallableStatementCallback<T> action) throws DataAccessException {
        return this.execute(new SimpleCallableStatementCreator(callString), action);
    }

    public Map<String, Object> call(CallableStatementCreator csc, List<SqlParameter> declaredParameters) throws DataAccessException {
        ArrayList<SqlParameter> updateCountParameters = new ArrayList<SqlParameter>();
        ArrayList<SqlParameter> resultSetParameters = new ArrayList<SqlParameter>();
        ArrayList<SqlParameter> callParameters = new ArrayList<SqlParameter>();
        for (SqlParameter parameter : declaredParameters) {
            if (parameter.isResultsParameter()) {
                if (parameter instanceof SqlReturnResultSet) {
                    resultSetParameters.add(parameter);
                    continue;
                }
                updateCountParameters.add(parameter);
                continue;
            }
            callParameters.add(parameter);
        }
        Map result = (Map)this.execute(csc, cs -> {
            boolean retVal = cs.execute();
            int updateCount = cs.getUpdateCount();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("CallableStatement.execute() returned '" + retVal + "'");
                this.logger.trace("CallableStatement.getUpdateCount() returned " + updateCount);
            }
            Map<String, Object> resultsMap = this.createResultsMap();
            if (retVal || updateCount != -1) {
                resultsMap.putAll(this.extractReturnedResults(cs, updateCountParameters, resultSetParameters, updateCount));
            }
            resultsMap.putAll(this.extractOutputParameters(cs, callParameters));
            return resultsMap;
        });
        Assert.state((result != null ? 1 : 0) != 0, (String)"No result map");
        return result;
    }

    protected Map<String, Object> extractReturnedResults(CallableStatement cs, @Nullable List<SqlParameter> updateCountParameters, @Nullable List<SqlParameter> resultSetParameters, int updateCount) throws SQLException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>(4);
        int rsIndex = 0;
        int updateIndex = 0;
        if (!this.skipResultsProcessing) {
            boolean moreResults;
            do {
                if (updateCount == -1) {
                    if (resultSetParameters != null && resultSetParameters.size() > rsIndex) {
                        SqlReturnResultSet declaredRsParam = (SqlReturnResultSet)resultSetParameters.get(rsIndex);
                        results.putAll(this.processResultSet(cs.getResultSet(), (ResultSetSupportingSqlParameter)declaredRsParam));
                        ++rsIndex;
                    } else if (!this.skipUndeclaredResults) {
                        String rsName = RETURN_RESULT_SET_PREFIX + (rsIndex + 1);
                        SqlReturnResultSet undeclaredRsParam = new SqlReturnResultSet(rsName, this.getColumnMapRowMapper());
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Added default SqlReturnResultSet parameter named '" + rsName + "'");
                        }
                        results.putAll(this.processResultSet(cs.getResultSet(), (ResultSetSupportingSqlParameter)undeclaredRsParam));
                        ++rsIndex;
                    }
                } else if (updateCountParameters != null && updateCountParameters.size() > updateIndex) {
                    SqlReturnUpdateCount ucParam = (SqlReturnUpdateCount)updateCountParameters.get(updateIndex);
                    String declaredUcName = ucParam.getName();
                    results.put(declaredUcName, updateCount);
                    ++updateIndex;
                } else if (!this.skipUndeclaredResults) {
                    String undeclaredName = RETURN_UPDATE_COUNT_PREFIX + (updateIndex + 1);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Added default SqlReturnUpdateCount parameter named '" + undeclaredName + "'");
                    }
                    results.put(undeclaredName, updateCount);
                    ++updateIndex;
                }
                moreResults = cs.getMoreResults();
                updateCount = cs.getUpdateCount();
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("CallableStatement.getUpdateCount() returned " + updateCount);
            } while (moreResults || updateCount != -1);
        }
        return results;
    }

    protected Map<String, Object> extractOutputParameters(CallableStatement cs, List<SqlParameter> parameters) throws SQLException {
        LinkedHashMap results = CollectionUtils.newLinkedHashMap((int)parameters.size());
        int sqlColIndex = 1;
        for (SqlParameter param : parameters) {
            if (param instanceof SqlOutParameter) {
                Object out;
                SqlOutParameter outParam = (SqlOutParameter)param;
                Assert.state((outParam.getName() != null ? 1 : 0) != 0, (String)"Anonymous parameters not allowed");
                SqlReturnType returnType = outParam.getSqlReturnType();
                if (returnType != null) {
                    out = returnType.getTypeValue(cs, sqlColIndex, outParam.getSqlType(), outParam.getTypeName());
                    results.put(outParam.getName(), out);
                } else {
                    out = cs.getObject(sqlColIndex);
                    if (out instanceof ResultSet) {
                        if (outParam.isResultSetSupported()) {
                            results.putAll(this.processResultSet((ResultSet)out, (ResultSetSupportingSqlParameter)outParam));
                        } else {
                            String rsName = outParam.getName();
                            SqlReturnResultSet rsParam = new SqlReturnResultSet(rsName, this.getColumnMapRowMapper());
                            results.putAll(this.processResultSet((ResultSet)out, (ResultSetSupportingSqlParameter)rsParam));
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Added default SqlReturnResultSet parameter named '" + rsName + "'");
                            }
                        }
                    } else {
                        results.put(outParam.getName(), out);
                    }
                }
            }
            if (param.isResultsParameter()) continue;
            ++sqlColIndex;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> processResultSet(@Nullable ResultSet rs, ResultSetSupportingSqlParameter param) throws SQLException {
        if (rs != null) {
            try {
                if (param.getRowMapper() != null) {
                    RowMapper rowMapper = param.getRowMapper();
                    List data = new RowMapperResultSetExtractor(rowMapper).extractData(rs);
                    Map<String, Object> map = Collections.singletonMap(param.getName(), data);
                    return map;
                }
                if (param.getRowCallbackHandler() != null) {
                    RowCallbackHandler rch = param.getRowCallbackHandler();
                    new RowCallbackHandlerResultSetExtractor(rch).extractData(rs);
                    Map<String, Object> map = Collections.singletonMap(param.getName(), "ResultSet returned from stored procedure was processed");
                    return map;
                }
                if (param.getResultSetExtractor() != null) {
                    Object data = param.getResultSetExtractor().extractData(rs);
                    Map<String, Object> map = Collections.singletonMap(param.getName(), data);
                    return map;
                }
            }
            finally {
                JdbcUtils.closeResultSet((ResultSet)rs);
            }
        }
        return Collections.emptyMap();
    }

    protected RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected <T> RowMapper<T> getSingleColumnRowMapper(Class<T> requiredType) {
        return new SingleColumnRowMapper(requiredType);
    }

    protected Map<String, Object> createResultsMap() {
        if (this.isResultsMapCaseInsensitive()) {
            return new LinkedCaseInsensitiveMap();
        }
        return new LinkedHashMap<String, Object>();
    }

    protected void applyStatementSettings(Statement stmt) throws SQLException {
        int maxRows;
        int fetchSize = this.getFetchSize();
        if (fetchSize != -1) {
            stmt.setFetchSize(fetchSize);
        }
        if ((maxRows = this.getMaxRows()) != -1) {
            stmt.setMaxRows(maxRows);
        }
    }

    protected PreparedStatementSetter newArgPreparedStatementSetter(@Nullable Object[] args) {
        return new ArgumentPreparedStatementSetter(args);
    }

    protected PreparedStatementSetter newArgTypePreparedStatementSetter(Object[] args, int[] argTypes) {
        return new ArgumentTypePreparedStatementSetter(args, argTypes);
    }

    protected void handleWarnings(Statement stmt) throws SQLException {
        if (this.isIgnoreWarnings()) {
            if (this.logger.isDebugEnabled()) {
                for (SQLWarning warningToLog = stmt.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                    this.logger.debug("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]");
                }
            }
        } else {
            this.handleWarnings(stmt.getWarnings());
        }
    }

    protected void handleWarnings(@Nullable SQLWarning warning) throws SQLWarningException {
        if (warning != null) {
            throw new SQLWarningException("Warning not ignored", warning);
        }
    }

    protected DataAccessException translateException(String task, @Nullable String sql, SQLException ex) {
        DataAccessException dae = this.exceptionTranslator.translate(task, sql, ex);
        return dae != null ? dae : new UncategorizedSQLException(task, sql, ex);
    }

    @Nullable
    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static <T> T result(@Nullable T result) {
        Assert.state((result != null ? 1 : 0) != 0, (String)"No result");
        return result;
    }

    private static int updateCount(@Nullable Integer result) {
        Assert.state((result != null ? 1 : 0) != 0, (String)"No update count");
        return result;
    }

    private Object invoke(Object object, int superClassLevel, String fieldName) {
        try {
            Class<?> clazz = object.getClass();
            for (int i = 0; i < superClassLevel; ++i) {
                clazz = clazz.getSuperclass();
            }
            Field declaredField = clazz.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return declaredField.get(object);
        }
        catch (NoSuchFieldException e) {
            this.logger.error(e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.error(e.getMessage());
        }
        throw new SdkException(String.format("Can't invoke '%s'.", fieldName));
    }

    private static class ResultSetSpliterator<T>
    implements Spliterator<T> {
        private final ResultSet rs;
        private final RowMapper<T> rowMapper;
        private int rowNum = 0;

        public ResultSetSpliterator(ResultSet rs, RowMapper<T> rowMapper) {
            this.rs = rs;
            this.rowMapper = rowMapper;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            try {
                if (this.rs.next()) {
                    action.accept(this.rowMapper.mapRow(this.rs, this.rowNum++));
                    return true;
                }
                return false;
            }
            catch (SQLException ex) {
                throw new InvalidResultSetAccessException(ex);
            }
        }

        @Override
        @Nullable
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 16;
        }

        public Stream<T> stream() {
            return StreamSupport.stream(this, false);
        }
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor<Object> {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        @Nullable
        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            return null;
        }
    }

    private static class SimpleCallableStatementCreator
    implements CallableStatementCreator,
    SqlProvider {
        private final String callString;

        public SimpleCallableStatementCreator(String callString) {
            Assert.notNull((Object)callString, (String)"Call string must not be null");
            this.callString = callString;
        }

        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            return con.prepareCall(this.callString);
        }

        public String getSql() {
            return this.callString;
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql) {
            Assert.notNull((Object)sql, (String)"SQL must not be null");
            this.sql = sql;
        }

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        public String getSql() {
            return this.sql;
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "close": {
                    return null;
                }
                case "isClosed": {
                    return false;
                }
                case "getTargetConnection": {
                    return this.target;
                }
                case "unwrap": {
                    return ((Class)args[0]).isInstance(proxy) ? proxy : this.target.unwrap((Class)args[0]);
                }
                case "isWrapperFor": {
                    return ((Class)args[0]).isInstance(proxy) || this.target.isWrapperFor((Class)args[0]);
                }
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Statement) {
                    DatabaseTemplate.this.applyStatementSettings((Statement)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

